/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.action;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.QuiltMeta;
import org.quiltmc.installer.VersionManifest;

public final class MinecraftInstallation {
    public static CompletableFuture<InstallationInfo> getInfo(String gameVersion, @Nullable String loaderVersion) {
        CompletionStage versionManifest = VersionManifest.create().thenApply(manifest -> {
            if (manifest.getVersion(gameVersion) != null) {
                return manifest;
            }
            throw new IllegalArgumentException(String.format("Minecraft version %s does not exist", gameVersion));
        });
        HashSet endpoints = new HashSet();
        endpoints.add(QuiltMeta.LOADER_VERSIONS_ENDPOINT);
        endpoints.add(QuiltMeta.INTERMEDIARY_VERSIONS_ENDPOINT);
        CompletableFuture<QuiltMeta> metaFuture = QuiltMeta.create("https://meta.quiltmc.org", "https://meta.fabricmc.net", endpoints);
        CompletionStage intermediary = ((CompletableFuture)versionManifest).thenCompose(mcVersion -> metaFuture.thenAccept(meta -> {
            Map<String, String> intermediaryVersions = meta.getEndpoint(QuiltMeta.INTERMEDIARY_VERSIONS_ENDPOINT);
            if (intermediaryVersions.get(gameVersion) == null) {
                throw new IllegalArgumentException(String.format("Minecraft version %s exists but has no intermediary", gameVersion));
            }
        }));
        CompletionStage loaderVersionFuture = metaFuture.thenApply(meta -> {
            List<String> versions = meta.getEndpoint(QuiltMeta.LOADER_VERSIONS_ENDPOINT);
            if (loaderVersion != null) {
                if (!versions.contains(loaderVersion)) {
                    throw new IllegalStateException(String.format("Specified loader version %s was not found", loaderVersion));
                }
                return versions.get(versions.indexOf(loaderVersion));
            }
            if (versions.size() == 0) {
                throw new IllegalStateException("No loader versions were found");
            }
            return versions.get(0);
        });
        return CompletableFuture.allOf(new CompletableFuture[]{versionManifest, intermediary, loaderVersionFuture}).thenApply(arg_0 -> MinecraftInstallation.lambda$getInfo$4((CompletableFuture)loaderVersionFuture, (CompletableFuture)versionManifest, arg_0));
    }

    private MinecraftInstallation() {
    }

    private static /* synthetic */ InstallationInfo lambda$getInfo$4(CompletableFuture loaderVersionFuture, CompletableFuture versionManifest, Void _v) {
        try {
            return new InstallationInfo((String)loaderVersionFuture.get(), (VersionManifest)versionManifest.get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class InstallationInfo {
        private final String loaderVersion;
        private final VersionManifest manifest;

        InstallationInfo(String loaderVersion, VersionManifest manifest) {
            this.loaderVersion = loaderVersion;
            this.manifest = manifest;
        }

        public String loaderVersion() {
            return this.loaderVersion;
        }

        public VersionManifest manifest() {
            return this.manifest;
        }
    }
}

