/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.action;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.Gsons;
import org.quiltmc.installer.LaunchJson;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.action.Action;
import org.quiltmc.installer.action.MinecraftInstallation;
import org.quiltmc.installer.lib.json5.JsonReader;

public final class InstallServer
extends Action<MessageType> {
    public static final String SERVICES_DIR = "META-INF/services/";
    private final String minecraftVersion;
    @Nullable
    private final String loaderVersion;
    private final String installDir;
    private final boolean createScripts;
    private final boolean installServer;
    private MinecraftInstallation.InstallationInfo installationInfo;
    private Path installedDir;

    InstallServer(String minecraftVersion, @Nullable String loaderVersion, String installDir, boolean createScripts, boolean installServer) {
        this.minecraftVersion = minecraftVersion;
        this.loaderVersion = loaderVersion;
        this.installDir = installDir;
        this.createScripts = createScripts;
        this.installServer = installServer;
    }

    @Override
    public void run(Consumer<MessageType> statusTracker) {
        Path installDir = this.installDir == null ? Paths.get(System.getProperty("user.dir"), new String[0]).resolve("server") : Paths.get(this.installDir, new String[0]);
        this.installedDir = installDir;
        InstallServer.println(String.format("Installing server launcher at: %s", installDir));
        if (this.loaderVersion == null) {
            InstallServer.println(String.format("Installing server launcher for %s", this.minecraftVersion));
        } else {
            InstallServer.println(String.format("Installing server launcher for %s with loader %s", this.minecraftVersion, this.loaderVersion));
        }
        CompletableFuture<MinecraftInstallation.InstallationInfo> installationInfoFuture = MinecraftInstallation.getInfo(this.minecraftVersion, this.loaderVersion);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)installationInfoFuture.thenCompose(installationInfo -> {
            this.installationInfo = installationInfo;
            return LaunchJson.get(this.minecraftVersion, installationInfo.loaderVersion(), "/v3/versions/loader/%s/%s/server/json");
        })).thenCompose(launchJson -> {
            CompletionStage completionStage;
            block13: {
                InstallServer.println("Installing libraries");
                JsonReader reader = JsonReader.json(new StringReader((String)launchJson));
                try {
                    Object read = Gsons.read(reader);
                    if (!(read instanceof Map)) {
                        throw new IllegalStateException("Cannot create server installation due to server endpoint returning wrong type.");
                    }
                    Map root = (Map)read;
                    String mainClass = (String)root.get("launcherMainClass");
                    if (mainClass == null) {
                        throw new IllegalStateException("launcherMainClass in server launch json was not present");
                    }
                    List libraries = (List)root.get("libraries");
                    if (libraries == null) {
                        throw new IllegalStateException("No libraries were specified!");
                    }
                    HashSet<CompletableFuture<Path>> libraryFiles = new HashSet<CompletableFuture<Path>>();
                    for (Object library : libraries) {
                        if (!(library instanceof Map)) {
                            throw new IllegalStateException("All libraries must be json objects!");
                        }
                        Map libraryFields = (Map)library;
                        String name = libraryFields.computeIfAbsent("name", k -> {
                            throw new IllegalStateException("Library had no name!");
                        });
                        String url = libraryFields.computeIfAbsent("url", k -> {
                            throw new IllegalStateException("Library had no url!");
                        });
                        libraryFiles.add(InstallServer.downloadLibrary(installDir.resolve("libraries"), name, url));
                    }
                    completionStage = CompletableFuture.allOf(libraryFiles.toArray(new CompletableFuture[0])).thenAccept(_v -> {
                        try {
                            if (Files.notExists(installDir, new LinkOption[0])) {
                                Files.createDirectories(installDir, new FileAttribute[0]);
                            }
                            InstallServer.createLaunchJar(installDir.resolve("quilt-server-launch.jar"), mainClass, libraryFiles);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    if (reader == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                reader.close();
            }
            return completionStage;
        })).thenCompose(_v -> {
            try {
                MinecraftInstallation.InstallationInfo installationInfo = (MinecraftInstallation.InstallationInfo)installationInfoFuture.get();
                if (this.createScripts) {
                    InstallServer.println("Creating launch scripts");
                }
                if (this.installServer) {
                    InstallServer.println("Downloading server");
                    return InstallServer.downloadServer(installDir, this.minecraftVersion, installationInfo);
                }
                return CompletableFuture.completedFuture(null);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        })).exceptionally(e -> {
            e.printStackTrace();
            return null;
        })).join();
    }

    public static CompletableFuture<Void> downloadServer(Path installDir, String minecraftVersion, MinecraftInstallation.InstallationInfo info) {
        return CompletableFuture.supplyAsync(() -> {
            Void void_;
            VersionManifest.Version version = info.manifest().getVersion(minecraftVersion);
            String rawUrl = version.url();
            URL url = new URL(rawUrl);
            URLConnection connection = url.openConnection();
            InputStreamReader stream = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(stream);
            try {
                String line;
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                    builder.append('\n');
                }
                String content = builder.toString();
                try (JsonReader json = JsonReader.json(new StringReader(content));){
                    Object read = Gsons.read(json);
                    if (!(read instanceof Map)) {
                        throw new IllegalStateException(String.format("launchermeta for %s is not an object!", minecraftVersion));
                    }
                    Object rawDownloads = ((Map)read).get("downloads");
                    if (!(rawDownloads instanceof Map)) {
                        throw new IllegalStateException("Downloads in launcher meta must be present and an object");
                    }
                    Object rawServer = ((Map)rawDownloads).get("server");
                    if (!(rawServer instanceof Map)) {
                        throw new IllegalStateException("Server downloads in launcher meta must be present and an object");
                    }
                    Object rawServerUrl = ((Map)rawServer).get("url");
                    if (rawServerUrl == null) {
                        throw new IllegalStateException("Server download url must be present");
                    }
                    InstallServer.println(String.format("Downloading %s server jar from %s", minecraftVersion, rawServerUrl.toString()));
                    try (InputStream serverDownloadStream = new URL(rawServerUrl.toString()).openConnection().getInputStream();){
                        Files.copy(serverDownloadStream, installDir.resolve("server.jar"), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                void_ = null;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
            return void_;
        });
    }

    private static CompletableFuture<Path> downloadLibrary(Path librariesDir, String name, String url) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path path = librariesDir.resolve(InstallServer.splitArtifact(name));
                String rawUrl = InstallServer.mavenToUrl(url, name);
                InstallServer.println("Downloading library at: " + rawUrl);
                URLConnection connection = new URL(rawUrl).openConnection();
                try (InputStream stream = connection.getInputStream();){
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
                }
                return path;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static void createLaunchJar(Path path, String mainClass, Set<CompletableFuture<Path>> libraries) throws IOException, ExecutionException, InterruptedException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        try (ZipOutputStream zipStream = new ZipOutputStream(Files.newOutputStream(path, StandardOpenOption.CREATE_NEW));){
            zipStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass);
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, libraries.stream().map(CompletableFuture::join).map(p -> path.getParent().relativize((Path)p).toString().replace("\\", "/")).collect(Collectors.joining(" ")));
            manifest.write(zipStream);
            zipStream.closeEntry();
        }
    }

    private static void parseServiceDefinition(String name, InputStream rawIs, Map<String, Set<String>> services) throws IOException {
        String line;
        Collection out = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(rawIs, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            int pos = line.indexOf(35);
            if (pos >= 0) {
                line = line.substring(0, pos);
            }
            if ((line = line.trim()).isEmpty()) continue;
            if (out == null) {
                out = services.computeIfAbsent(name, ignore -> new LinkedHashSet());
            }
            out.add(line);
        }
    }

    private static void writeServiceDefinition(Collection<String> entries, OutputStream stream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
        for (String def : entries) {
            writer.write(def);
            writer.write(10);
        }
        writer.flush();
    }

    private static String mavenToUrl(String mavenUrl, String artifactNotation) {
        return mavenUrl + InstallServer.splitArtifact(artifactNotation);
    }

    private static String splitArtifact(String artifactNotation) {
        String[] parts = artifactNotation.split(":", 3);
        String path = parts[0].replace(".", "/") + "/" + parts[1] + "/" + parts[2] + "/" + parts[1] + "-" + parts[2] + ".jar";
        return path;
    }

    public String minecraftVersion() {
        return this.minecraftVersion;
    }

    public MinecraftInstallation.InstallationInfo installationInfo() {
        return this.installationInfo;
    }

    public Path installedDir() {
        return this.installedDir;
    }

    public static final class MessageType
    extends Enum<MessageType> {
        private static final /* synthetic */ MessageType[] $VALUES;

        public static MessageType[] values() {
            return (MessageType[])$VALUES.clone();
        }

        public static MessageType valueOf(String name) {
            return Enum.valueOf(MessageType.class, name);
        }

        private static /* synthetic */ MessageType[] $values() {
            return new MessageType[0];
        }

        static {
            $VALUES = MessageType.$values();
        }
    }
}

