/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.action;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.LaunchJson;
import org.quiltmc.installer.LauncherProfiles;
import org.quiltmc.installer.OsPaths;
import org.quiltmc.installer.action.Action;
import org.quiltmc.installer.action.MinecraftInstallation;

public final class InstallClient
extends Action<MessageType> {
    private final String minecraftVersion;
    @Nullable
    private final String loaderVersion;
    private final String installDir;
    private final boolean generateProfile;
    private Path installDirPath;

    InstallClient(String minecraftVersion, @Nullable String loaderVersion, String installDir, boolean generateProfile) {
        this.minecraftVersion = minecraftVersion;
        this.loaderVersion = loaderVersion;
        this.installDir = installDir;
        this.generateProfile = generateProfile;
    }

    @Override
    public void run(Consumer<MessageType> statusTracker) {
        Path installDir = this.installDir == null ? OsPaths.getDefaultInstallationDir() : Paths.get(this.installDir, new String[0]);
        this.installDirPath = installDir;
        InstallClient.println(String.format("Installing Minecraft client at: %s", installDir));
        if (this.loaderVersion != null) {
            InstallClient.println(String.format("Installing Minecraft client of version %s with loader version %s", this.minecraftVersion, this.loaderVersion));
        } else {
            InstallClient.println(String.format("Installing Minecraft client of version %s", this.minecraftVersion));
        }
        CompletableFuture<MinecraftInstallation.InstallationInfo> installationInfoFuture = MinecraftInstallation.getInfo(this.minecraftVersion, this.loaderVersion);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)installationInfoFuture.thenCompose(installationInfo -> LaunchJson.get(this.minecraftVersion, installationInfo.loaderVersion(), "/v3/versions/loader/%s/%s/profile/json"))).thenAccept(launchJson -> {
            InstallClient.println("Creating profile launch json");
            try {
                String profileName = String.format("%s-%s-%s", "quilt-loader", ((MinecraftInstallation.InstallationInfo)installationInfoFuture.get()).loaderVersion(), this.minecraftVersion);
                Path versionsDir = this.installDirPath.resolve("versions");
                Path profileDir = versionsDir.resolve(profileName);
                Path profileJson = profileDir.resolve(profileName + ".json");
                try {
                    Files.walk(profileDir, new FileVisitOption[0]).map(Path::toFile).sorted((o1, o2) -> -o1.compareTo((File)o2)).forEach(File::delete);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Files.createDirectories(profileDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                try {
                    Files.createFile(profileDir.resolve(profileName + ".jar"), new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException e) {
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(profileJson, StandardOpenOption.CREATE_NEW));){
                    ((Writer)writer).append((CharSequence)launchJson);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (this.generateProfile) {
                    try {
                        InstallClient.println("Creating new profile");
                        LauncherProfiles.updateProfiles(this.installDirPath, profileName, this.minecraftVersion);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                InstallClient.println("Completed installation");
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        })).exceptionally(e -> {
            InstallClient.eprintln("Failed to install client");
            e.printStackTrace();
            System.exit(1);
            return null;
        })).join();
    }

    public static final class MessageType
    extends Enum<MessageType> {
        private static final /* synthetic */ MessageType[] $VALUES;

        public static MessageType[] values() {
            return (MessageType[])$VALUES.clone();
        }

        public static MessageType valueOf(String name) {
            return Enum.valueOf(MessageType.class, name);
        }

        private static /* synthetic */ MessageType[] $values() {
            return new MessageType[0];
        }

        static {
            $VALUES = MessageType.$values();
        }
    }
}

