/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public final class Localization {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("lang/installer", Locale.getDefault(), new LocaleFactory());

    public static String get(String key) {
        try {
            return BUNDLE.getString(key);
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
            return key;
        }
    }

    public static String createFrom(String key, Object ... arguments) {
        try {
            return new MessageFormat(BUNDLE.getString(key)).format(arguments);
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
            return key;
        }
    }

    private static final class LocaleFactory
    extends ResourceBundle.Control {
        private LocaleFactory() {
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            try (InputStream stream = loader.getResourceAsStream(resourceName);){
                if (stream != null) {
                    PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(stream);
                    return propertyResourceBundle;
                }
            }
            return super.newBundle(baseName, locale, format, loader, reload);
        }
    }
}

