/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.quiltmc.installer.Gsons;
import org.quiltmc.installer.lib.json5.JsonReader;
import org.quiltmc.installer.lib.json5.JsonWriter;

public final class LaunchJson {
    public static final String LOADER_ARTIFACT_NAME = "quilt-loader";

    public static CompletableFuture<String> get(String gameVersion, String loaderVersion, String endpoint) {
        String rawUrl = "https://meta.quiltmc.org" + String.format(endpoint, gameVersion, loaderVersion);
        return CompletableFuture.supplyAsync(() -> {
            String string;
            URL url = new URL(rawUrl);
            URLConnection connection = url.openConnection();
            InputStreamReader stream = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(stream);
            try {
                String line;
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                    builder.append('\n');
                }
                string = builder.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
            return string;
        }).thenApplyAsync(raw -> {
            Map map;
            try {
                map = (Map)Gsons.read(JsonReader.json(raw));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            List libraries = (List)map.get("libraries");
            for (Map library : libraries) {
                if (!((String)library.get("name")).startsWith("org.quiltmc:hashed")) continue;
                library.replace("name", ((String)library.get("name")).replace("org.quiltmc:hashed", "net.fabricmc:intermediary"));
                library.replace("url", "https://maven.fabricmc.net/");
            }
            StringWriter writer = new StringWriter();
            try {
                Gsons.write(JsonWriter.json(writer), map);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return writer.toString();
        });
    }

    private LaunchJson() {
    }
}

