/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.google.common.base.Stopwatch;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.EntryPanelOrdering;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.view.Views;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.search.AsyncSearchManager;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsibleEntryRegistryImpl;
import net.minecraft.class_310;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class EntryListSearchManager {
    private static final Comparator<? super EntryStack<?>> ENTRY_NAME_COMPARER = Comparator.comparing(stack -> stack.asFormatStrippedText().getString());
    public static final EntryListSearchManager INSTANCE = new EntryListSearchManager();
    private AsyncSearchManager searchManager = new AsyncSearchManager(EntryRegistry.getInstance()::getPreFilteredList, () -> {
        LongOpenHashSet workingItems;
        boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled();
        LongOpenHashSet longOpenHashSet = workingItems = checkCraftable ? new LongOpenHashSet() : null;
        if (checkCraftable) {
            for (EntryStack<?> stack2 : Views.getInstance().findCraftableEntriesByMaterials()) {
                workingItems.add(EntryStacks.hashExact(stack2));
            }
        }
        return checkCraftable ? arg_0 -> EntryListSearchManager.lambda$new$1((LongSet)workingItems, arg_0) : stack -> true;
    }, EntryStack::normalize);

    public void update(String searchTerm, boolean ignoreLastSearch, Consumer<List<Object>> update) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (ignoreLastSearch) {
            this.searchManager.markDirty();
        }
        this.searchManager.updateFilter(searchTerm);
        if (this.searchManager.isDirty()) {
            this.searchManager.getAsync((list, filter) -> {
                if (!filter.getFilter().equals(searchTerm)) {
                    return;
                }
                if (this.searchManager.filter() == null || this.searchManager.filter() != filter) {
                    return;
                }
                InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Search \"%s\" Used [%s]: %s", filter.getFilter(), Thread.currentThread().toString(), stopwatch.toString());
                List<Object> finalList = this.collapse(this.copyAndOrder((List<EntryStack<?>>)list), () -> this.searchManager.filter() != null && this.searchManager.filter() == filter);
                InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Search \"%s\" Used and Applied [%s]: %s", filter.getFilter(), Thread.currentThread().toString(), stopwatch.stop().toString());
                class_310.method_1551().method_20493(() -> {
                    if (this.searchManager.filter() == null || this.searchManager.filter() != filter) {
                        return;
                    }
                    update.accept(finalList);
                });
            });
        }
    }

    private List<EntryStack<?>> copyAndOrder(List<EntryStack<?>> list) {
        list = new ArrayList(list);
        EntryPanelOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
        if (ordering == EntryPanelOrdering.NAME) {
            list.sort(ENTRY_NAME_COMPARER);
        }
        if (!ConfigObject.getInstance().isItemListAscending()) {
            Collections.reverse(list);
        }
        return list;
    }

    private List<Object> collapse(List<EntryStack<?>> stacks, BooleanSupplier isValid) {
        CollapsibleEntryRegistryImpl collapsibleRegistry = (CollapsibleEntryRegistryImpl)CollapsibleEntryRegistry.getInstance();
        HashMap<CollapsibleEntryRegistryImpl.Entry, @Nullable V> entries = new HashMap();
        for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getEntries()) {
            entries.put(entry, null);
        }
        if (!isValid.getAsBoolean()) {
            return List.of();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        for (EntryStack<?> stack : stacks) {
            long hashExact = EntryStacks.hashExact(stack);
            boolean matchedAny = false;
            for (Map.Entry entry : entries.entrySet()) {
                CollapsibleEntryRegistryImpl.Entry entry2 = (CollapsibleEntryRegistryImpl.Entry)entry.getKey();
                if (!entry2.getMatcher().matches(stack, hashExact)) continue;
                CollapsedStack collapsed = (CollapsedStack)entry.getValue();
                if (collapsed == null) {
                    ArrayList ingredient = new ArrayList();
                    ingredient.add(stack);
                    collapsed = new CollapsedStack(ingredient, entry2);
                    entry.setValue(collapsed);
                    list.add(collapsed);
                } else {
                    collapsed.getIngredient().add(stack);
                }
                matchedAny = true;
            }
            if (i++ % 50 == 0 && !isValid.getAsBoolean()) {
                return List.of();
            }
            if (matchedAny) continue;
            list.add(stack);
        }
        return list;
    }

    public boolean matches(EntryStack<?> stack) {
        return this.searchManager.matches(stack);
    }

    private static /* synthetic */ boolean lambda$new$1(LongSet workingItems, EntryStack stack) {
        return workingItems.contains(EntryStacks.hashExact(stack));
    }
}

