/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class DisplayCompositeWidget
extends DelegateWidgetWithBounds
implements DraggableComponentProviderWidget<Object> {
    private final DisplaySpec display;

    public DisplayCompositeWidget(DisplaySpec display, List<Widget> widgets, Rectangle bounds) {
        super(Widgets.concat(widgets), () -> bounds);
        this.display = display;
    }

    @Override
    @Nullable
    public DraggableComponent<Object> getHovered(DraggingContext<class_437> context, double mouseX, double mouseY) {
        return StreamSupport.stream(Widgets.walk(this.widget.method_25396(), widget -> widget instanceof DraggableComponentProviderWidget).spliterator(), false).map(widget -> widget.getHovered(context, mouseX, mouseY)).filter(Objects::nonNull).findFirst().orElseGet(() -> {
            if (this.containsMouse(mouseX, mouseY)) {
                return new DisplayDraggableComponent(this.widget, this.display.provideInternalDisplay(), this.getBounds(), this.getBounds());
            }
            return null;
        });
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        FavoritesListWidget favoritesListWidget;
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(DisplayCompositeWidget.mouse()) && ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(keyCode, scanCode) && (favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget()) != null) {
            favoritesListWidget.displayHistory.addDisplay(this.getBounds().clone(), this.display.provideInternalDisplay());
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        FavoritesListWidget favoritesListWidget;
        if (super.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(mouseX, mouseY) && ConfigObject.getInstance().getFavoriteKeyCode().matchesMouse(button) && (favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget()) != null) {
            favoritesListWidget.displayHistory.addDisplay(this.getBounds().clone(), this.display.provideInternalDisplay());
            return true;
        }
        return false;
    }

    public static class DisplayDraggableComponent
    implements DraggableComponent<Display> {
        private final Widget widget;
        private final Display display;
        private final Rectangle originBounds;
        private final Rectangle bounds;

        public DisplayDraggableComponent(Widget widget, Display display, Rectangle originBounds, Rectangle bounds) {
            this.widget = widget;
            this.display = display;
            this.originBounds = originBounds;
            this.bounds = bounds;
        }

        @Override
        public int getWidth() {
            return this.bounds.width;
        }

        @Override
        public int getHeight() {
            return this.bounds.height;
        }

        @Override
        public Display get() {
            return this.display;
        }

        @Override
        public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            matrices.method_22903();
            matrices.method_46416((float)bounds.getX(), (float)bounds.getY(), 0.0f);
            matrices.method_22905((float)bounds.width / (float)this.bounds.getWidth(), (float)bounds.height / (float)this.bounds.getHeight(), 1.0f);
            matrices.method_46416((float)(-this.bounds.getX()), (float)(-this.bounds.getY()), 0.0f);
            this.widget.method_25394(matrices, -1000, -1000, delta);
            matrices.method_22909();
        }

        @Override
        public void release(DraggedAcceptorResult result) {
            if (result == DraggedAcceptorResult.PASS) {
                DraggingContext.getInstance().renderBack(this, DraggingContext.getInstance().getCurrentBounds(), () -> this.originBounds);
            }
        }

        @Override
        public Rectangle getOriginBounds(Point mouse) {
            return this.originBounds.clone();
        }
    }
}

