/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.architectury.fluid.FluidStack;
import dev.architectury.utils.value.IntValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.TabContainerWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public abstract class AbstractDisplayViewingScreen
extends class_437
implements DisplayScreen {
    protected final Map<DisplayCategory<?>, List<DisplaySpec>> categoryMap;
    protected final List<DisplayCategory<?>> categories;
    protected final TabContainerWidget tabs = new TabContainerWidget();
    protected List<EntryStack<?>> ingredientStackToNotice = new ArrayList();
    protected List<EntryStack<?>> resultStackToNotice = new ArrayList();
    protected int selectedCategoryIndex = 0;
    protected int categoryPages = -1;
    protected Rectangle bounds;
    private static final int MAX_WIDTH = 200;

    protected AbstractDisplayViewingScreen(Map<DisplayCategory<?>, List<DisplaySpec>> categoryMap, @Nullable CategoryIdentifier<?> category) {
        super((class_2561)class_2561.method_43473());
        this.categoryMap = categoryMap;
        this.categories = Lists.newArrayList(categoryMap.keySet());
        if (category != null) {
            this.selectCategory(category, false);
        }
    }

    protected void selectCategory(CategoryIdentifier<?> category) {
        this.selectCategory(category, true);
    }

    protected void selectCategory(CategoryIdentifier<?> category, boolean init) {
        for (int i = 0; i < this.categories.size(); ++i) {
            if (!this.categories.get(i).getCategoryIdentifier().equals(category)) continue;
            this.selectedCategoryIndex = i;
            break;
        }
        this.recalculateCategoryPage();
        this.tabs.updateScroll(this.categories, this.selectedCategoryIndex, !init ? 0L : 300L);
        if (init) {
            this.method_25426();
        }
    }

    @Override
    public void recalculateCategoryPage() {
        this.categoryPages = -1;
    }

    protected void initTabs(int width) {
        this.tabs.init(new Rectangle(this.bounds.getCenterX() - width / 2, this.bounds.y - 28, width, 28), new Rectangle(this.bounds.getCenterX() - width / 2, this.bounds.y - 28, width, 28), this.categories, new IntValue(){

            public void accept(int value) {
                AbstractDisplayViewingScreen.this.categoryPages = value;
            }

            public int getAsInt() {
                return AbstractDisplayViewingScreen.this.categoryPages;
            }
        }, new IntValue(){

            public void accept(int value) {
                AbstractDisplayViewingScreen.this.selectCategory(AbstractDisplayViewingScreen.this.categories.get(value).getCategoryIdentifier());
            }

            public int getAsInt() {
                return AbstractDisplayViewingScreen.this.selectedCategoryIndex;
            }
        }, () -> ((AbstractDisplayViewingScreen)this).method_25426());
    }

    public List<class_364> method_25396() {
        List children = super.method_25396();
        children.sort(Comparator.comparingDouble(value -> {
            double d;
            if (value instanceof Widget) {
                Widget widget = (Widget)value;
                d = widget.getZRenderingPriority();
            } else {
                d = 0.0;
            }
            return d;
        }).reversed());
        return children;
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void addIngredientToNotice(EntryStack<?> stack) {
        if (stack == null) {
            return;
        }
        this.ingredientStackToNotice.add(stack);
    }

    @Override
    public void addResultToNotice(EntryStack<?> stack) {
        if (stack == null) {
            return;
        }
        this.resultStackToNotice.add(stack);
    }

    @Override
    public List<EntryStack<?>> getIngredientsToNotice() {
        return Collections.unmodifiableList(this.ingredientStackToNotice);
    }

    @Override
    public List<EntryStack<?>> getResultsToNotice() {
        return Collections.unmodifiableList(this.resultStackToNotice);
    }

    @Override
    public DisplayCategory<Display> getCurrentCategory() {
        return this.categories.get(this.selectedCategoryIndex);
    }

    protected DisplayCategoryView<Display> getCurrentCategoryView(Display display) {
        return CategoryRegistry.getInstance().get(display.getCategoryIdentifier().cast()).getView(display);
    }

    @Override
    public void previousCategory() {
        int currentCategoryIndex = this.selectedCategoryIndex;
        if (--currentCategoryIndex < 0) {
            currentCategoryIndex = this.categories.size() - 1;
        }
        this.selectCategory(this.categories.get(currentCategoryIndex).getCategoryIdentifier());
    }

    @Override
    public void nextCategory() {
        int currentCategoryIndex = this.selectedCategoryIndex;
        if (++currentCategoryIndex >= this.categories.size()) {
            currentCategoryIndex = 0;
        }
        this.selectCategory(this.categories.get(currentCategoryIndex).getCategoryIdentifier());
    }

    protected void transformIngredientNotice(List<Widget> setupDisplay, List<EntryStack<?>> noticeStacks) {
        AbstractDisplayViewingScreen.transformNotice(1, setupDisplay, noticeStacks);
    }

    protected void transformResultNotice(List<Widget> setupDisplay, List<EntryStack<?>> noticeStacks) {
        AbstractDisplayViewingScreen.transformNotice(2, setupDisplay, noticeStacks);
    }

    private static void transformNotice(int marker, List<? extends class_364> setupDisplay, List<EntryStack<?>> noticeStacks) {
        if (noticeStacks.isEmpty()) {
            return;
        }
        block0: for (EntryWidget widget : Widgets.walk(setupDisplay, EntryWidget.class::isInstance)) {
            if (widget.getNoticeMark() != marker || widget.getEntries().size() <= 1) continue;
            for (EntryStack<?> noticeStack : noticeStacks) {
                EntryStack<?> stack = CollectionUtils.findFirstOrNullEqualsExact(widget.getEntries(), noticeStack);
                if (stack == null) continue;
                widget.clearStacks();
                widget.entry((EntryStack)stack);
                continue block0;
            }
        }
    }

    protected void transformFiltering(List<? extends class_364> setupDisplay) {
        for (EntryWidget widget : Widgets.walk(setupDisplay, EntryWidget.class::isInstance)) {
            Collection<EntryStack<?>> refiltered;
            if (widget.getEntries().size() <= 1 || (refiltered = EntryRegistry.getInstance().refilterNew(false, widget.getEntries())).isEmpty()) continue;
            widget.clearStacks();
            widget.entries(refiltered);
        }
    }

    protected void setupTags(List<Widget> widgets) {
        block0: for (EntryWidget widget : Widgets.walk(widgets, EntryWidget.class::isInstance)) {
            List<class_6880> objects;
            class_7922 registry;
            if (widget.getNoticeMark() != 1) continue;
            this.addCyclingTooltip(widget);
            widget.removeTagMatch = false;
            if (widget.getEntries().size() <= 1) continue;
            EntryType<?> type = null;
            for (EntryStack<?> entry : widget.getEntries()) {
                if (type == null) {
                    type = entry.getType();
                    continue;
                }
                if (type == entry.getType()) continue;
                continue block0;
            }
            if (type == VanillaEntryTypes.ITEM) {
                registry = class_7923.field_41178;
                objects = CollectionUtils.map(widget.getEntries(), stack -> ((class_1799)stack.castValue()).method_7909().method_40131());
            } else {
                if (type != VanillaEntryTypes.FLUID) continue;
                registry = class_7923.field_41173;
                objects = CollectionUtils.map(widget.getEntries(), stack -> ((FluidStack)stack.castValue()).getFluid().method_40178());
            }
            Stream<class_6862> collection = registry.method_40272().filter(pair -> ((class_6885.class_6888)pair.getSecond()).method_40247() == objects.size()).map(Pair::getFirst);
            class_6862 firstOrNull = CollectionUtils.findFirstOrNull(collection::iterator, key -> CollectionUtils.allMatch(objects, holder -> holder.method_40220(key)));
            if (firstOrNull == null) continue;
            widget.tagMatch = firstOrNull.comp_327();
        }
    }

    private void addCyclingTooltip(final EntryWidget widget) {
        class TooltipProcessor
        implements UnaryOperator<Tooltip>,
        class_5632,
        class_5684 {
            TooltipProcessor() {
            }

            @Override
            public Tooltip apply(Tooltip tooltip) {
                if (widget.getEntries().size() > 1) {
                    for (Tooltip.Entry entry : tooltip.entries()) {
                        if (!entry.isTooltipComponent() || !(entry.getAsTooltipComponent() instanceof TooltipProcessor)) continue;
                        return tooltip;
                    }
                    tooltip.add(this);
                }
                return tooltip;
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof TooltipProcessor;
            }

            public int method_32661() {
                int entrySize = EntryListWidget.entrySize();
                int w = Math.max(1, 200 / entrySize);
                int height = Math.min(6, class_3532.method_15386((float)((float)widget.getEntries().size() / (float)w))) * entrySize + 2;
                height += 12;
                if (widget.tagMatch != null) {
                    height += 12;
                }
                return height;
            }

            public int method_32664(class_327 font) {
                int entrySize = EntryListWidget.entrySize();
                int w = Math.max(1, 200 / entrySize);
                int size = widget.getEntries().size();
                int width = Math.min(size, w) * entrySize;
                width = Math.max(width, font.method_27525((class_5348)class_2561.method_43471((String)"text.rei.accepts")));
                if (widget.tagMatch != null) {
                    width = Math.max(width, font.method_27525((class_5348)class_2561.method_43469((String)"text.rei.tag_accept", (Object[])new Object[]{widget.tagMatch.toString()})));
                }
                return width;
            }

            public void method_32666(class_327 font, int x, int y, class_4587 poses, class_918 renderer) {
                int entrySize = EntryListWidget.entrySize();
                int w = Math.max(1, 200 / entrySize);
                int i = 0;
                poses.method_22903();
                poses.method_46416(0.0f, 0.0f, 50.0f);
                for (EntryStack<?> entry : widget.getEntries()) {
                    int x1 = x + i % w * entrySize;
                    int y1 = y + 13 + i / w * entrySize;
                    if (++i / w > 5) {
                        class_4597.class_4598 source = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                        class_5250 text = class_2561.method_43470((String)("+" + (widget.getEntries().size() - w * 6 + 1))).method_27692(class_124.field_1080);
                        font.method_30882((class_2561)text, (float)(x1 + entrySize / 2 - font.method_27525((class_5348)text) / 2), (float)(y1 + entrySize / 2 - 1), -1, true, poses.method_23760().method_23761(), (class_4597)source, class_327.class_6415.field_33993, 0, 0xF000F0);
                        source.method_22993();
                        break;
                    }
                    entry.render(poses, new Rectangle(x1, y1, entrySize, entrySize), -1000, -1000, 0.0f);
                }
                poses.method_22909();
            }

            public void method_32665(class_327 font, int x, int y, Matrix4f pose, class_4597.class_4598 buffers) {
                font.method_30882((class_2561)class_2561.method_43471((String)"text.rei.accepts").method_27692(class_124.field_1080), (float)x, (float)(y + 2), -1, true, pose, (class_4597)buffers, class_327.class_6415.field_33993, 0, 0xF000F0);
                if (widget.tagMatch != null) {
                    int entrySize = EntryListWidget.entrySize();
                    int w = Math.max(1, 200 / entrySize);
                    font.method_30882((class_2561)class_2561.method_43469((String)"text.rei.tag_accept", (Object[])new Object[]{widget.tagMatch.toString()}).method_27692(class_124.field_1080), (float)x, (float)(y + 16 + Math.min(6, class_3532.method_15386((float)((float)widget.getEntries().size() / (float)w))) * entrySize), -1, true, pose, (class_4597)buffers, class_327.class_6415.field_33993, 0, 0xF000F0);
                }
            }
        }
        widget.tooltipProcessor(new TooltipProcessor());
    }

    protected static ScreenOverlay getOverlay() {
        return REIRuntime.getInstance().getOverlay().orElseThrow(() -> new IllegalStateException("Overlay not initialized!"));
    }

    private boolean handleFocuses(int button) {
        if (button == 0) {
            this.method_25398(true);
        }
        this.handleFocuses();
        return true;
    }

    private boolean handleFocuses() {
        if (this.method_25399() instanceof ScreenOverlay || this.method_25399() == this) {
            this.method_25395(null);
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button) || AbstractDisplayViewingScreen.getOverlay().method_25402(mouseX, mouseY, button) && this.handleFocuses(button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button) || AbstractDisplayViewingScreen.getOverlay().method_25406(mouseX, mouseY, button) && this.handleFocuses();
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY) || AbstractDisplayViewingScreen.getOverlay().method_25403(mouseX, mouseY, button, deltaX, deltaY) && this.handleFocuses();
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return super.method_25401(mouseX, mouseY, amount) || AbstractDisplayViewingScreen.getOverlay().method_25401(mouseX, mouseY, amount) && this.handleFocuses();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers) || AbstractDisplayViewingScreen.getOverlay().method_25404(keyCode, scanCode, modifiers) && this.handleFocuses()) {
            return true;
        }
        if (ConfigObject.getInstance().getPreviousScreenKeybind().matchesKey(keyCode, scanCode)) {
            if (REIRuntimeImpl.getInstance().hasLastDisplayScreen()) {
                this.field_22787.method_1507(REIRuntimeImpl.getInstance().getLastDisplayScreen());
            } else {
                this.field_22787.method_1507(REIRuntime.getInstance().getPreviousScreen());
            }
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            class_310.method_1551().method_1507(REIRuntime.getInstance().getPreviousScreen());
            return true;
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return super.method_16803(keyCode, scanCode, modifiers) || AbstractDisplayViewingScreen.getOverlay().method_16803(keyCode, scanCode, modifiers) && this.handleFocuses();
    }

    public boolean method_25400(char character, int modifiers) {
        return super.method_25400(character, modifiers) || AbstractDisplayViewingScreen.getOverlay().method_25400(character, modifiers) && this.handleFocuses();
    }
}

