/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.changelog;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import me.shedaniel.rei.impl.client.gui.changelog.JParseDown;
import me.shedaniel.rei.impl.client.gui.changelog.JParseDownToMinecraft;
import me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget;
import me.shedaniel.rei.impl.client.gui.error.ErrorsScreen;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.commons.io.IOUtils;

public class ChangelogLoader {
    private static Boolean visited = null;

    public static boolean hasVisited() {
        if (visited == null) {
            visited = false;
            File file = Platform.getConfigFolder().resolve("roughlyenoughitems/changelog.txt").toFile();
            if (file.exists()) {
                try (FileReader reader = new FileReader(file);){
                    JsonObject object;
                    String currentVersion;
                    String version = IOUtils.toString((Reader)reader).trim();
                    InputStream changesJsonStream = ChangelogLoader.class.getClassLoader().getResourceAsStream("roughlyenoughitems.changes.json");
                    if (changesJsonStream != null && (currentVersion = (object = JsonParser.parseReader((Reader)new InputStreamReader(changesJsonStream)).getAsJsonObject()).getAsJsonPrimitive("version").getAsString()).equals(version)) {
                        visited = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return visited;
    }

    public static void show() {
        visited = true;
        class BuilderImpl
        implements Builder {
            private final List<Object> components = new ArrayList<Object>();

            BuilderImpl() {
            }

            @Override
            public void add(Function<Integer, ErrorsEntryListWidget.Entry> function) {
                this.components.add(function);
            }
        }
        BuilderImpl builder = new BuilderImpl();
        InputStream changesJsonStream = ChangelogLoader.class.getClassLoader().getResourceAsStream("roughlyenoughitems.changes.json");
        if (changesJsonStream == null) {
            builder.add((class_2561)class_2561.method_43471((String)"rei.changelog.error.missingChangelogFile"));
        } else {
            JsonObject object = JsonParser.parseReader((Reader)new InputStreamReader(changesJsonStream)).getAsJsonObject();
            String version = object.getAsJsonPrimitive("version").getAsString();
            Path file = Platform.getConfigFolder().resolve("roughlyenoughitems/changelog.txt");
            try {
                Files.write(file, version.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            InputStream changelogStream = ChangelogLoader.class.getClassLoader().getResourceAsStream("roughlyenoughitems/" + version + "/changelog.md");
            if (changelogStream == null) {
                builder.add((class_2561)class_2561.method_43471((String)"rei.changelog.error.missingChangelogFile"));
            } else {
                try {
                    JParseDown parseDown = new JParseDown();
                    LinkedList<JParseDown.Block> blocks = parseDown.linesElements(IOUtils.readLines((InputStream)changelogStream, (Charset)StandardCharsets.UTF_8).toArray(new String[0]));
                    for (JParseDown.Block block : blocks) {
                        if (block.autoBreak.booleanValue()) {
                            builder.add(width -> new ErrorsEntryListWidget.EmptyEntry(6));
                        }
                        Builder blockBuilder = builder;
                        if (block instanceof JParseDown.BlockHeader) {
                            blockBuilder = function -> builder.add(width -> new ErrorsEntryListWidget.ScaledEntry((ErrorsEntryListWidget.Entry)((Object)((Object)((Object)function.apply(Math.round((float)width.intValue() / 1.5f))))), 1.5f));
                        }
                        JParseDownToMinecraft.build(blockBuilder, block);
                        if (!block.autoBreak.booleanValue()) continue;
                        builder.add(width -> new ErrorsEntryListWidget.EmptyEntry(6));
                    }
                }
                catch (IOException e) {
                    builder.add((class_2561)class_2561.method_43471((String)"rei.changelog.error.failedToReadChangelogFile"));
                }
            }
        }
        class_310.method_1551().method_1507((class_437)new ErrorsScreen((class_2561)class_2561.method_43471((String)"text.rei.changelog.title"), builder.components, class_310.method_1551().field_1755, true));
    }

    public static interface Builder {
        default public void add(class_2561 component) {
            this.add((Integer width) -> new ErrorsEntryListWidget.TextEntry(component, (int)width));
        }

        public void add(Function<Integer, ErrorsEntryListWidget.Entry> var1);
    }
}

