/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.quilt;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.plugin.PluginLoader;
import net.fabricmc.api.EnvType;
import org.quiltmc.loader.api.LoaderValue;
import org.quiltmc.loader.api.ModContainer;
import org.quiltmc.loader.api.ModMetadata;
import org.quiltmc.loader.api.QuiltLoader;
import org.quiltmc.loader.api.minecraft.MinecraftQuiltLoader;

public class QuiltPluginLoader
extends PluginLoader {
    @Override
    protected void gatherPlugins() {
        Object2ObjectOpenHashMap pluginMap = new Object2ObjectOpenHashMap();
        for (ModContainer modContainer : QuiltLoader.getAllMods()) {
            for (String file : PLUGIN_JSON_FILES) {
                Path path = modContainer.getPath(file);
                if (!Files.exists(path, new LinkOption[0])) continue;
                this.readPluginsJson(modContainer.metadata().id(), path);
            }
            ModMetadata data = modContainer.metadata();
            if (!data.containsValue("waila:plugins")) continue;
            LoaderValue val = Objects.requireNonNull(data.value("waila:plugins"));
            if (val.type() == LoaderValue.LType.OBJECT) {
                pluginMap.put(modContainer, new LoaderValue.LObject[]{val.asObject()});
                continue;
            }
            if (val.type() == LoaderValue.LType.ARRAY) {
                pluginMap.put(modContainer, (LoaderValue.LObject[])val.asArray().stream().map(LoaderValue::asObject).toArray(LoaderValue.LObject[]::new));
                continue;
            }
            Waila.LOGGER.error("Plugin data provided by {} must be an object or array of objects.", (Object)data.id());
        }
        for (Map.Entry entry : pluginMap.entrySet()) {
            LoaderValue.LObject[] plugins;
            ModContainer mod = (ModContainer)entry.getKey();
            block13: for (LoaderValue.LObject plugin : plugins = (LoaderValue.LObject[])entry.getValue()) {
                IPluginInfo.Side side;
                String sideStr;
                ArrayList<String> requiredDeps = new ArrayList<String>();
                if (plugin.containsKey((Object)"required")) {
                    LoaderValue required = Objects.requireNonNull(plugin.get((Object)"required"));
                    if (required.type() == LoaderValue.LType.STRING) {
                        if (!QuiltLoader.isModLoaded((String)required.asString())) continue;
                        requiredDeps.add(required.asString());
                    }
                    if (required.type() == LoaderValue.LType.ARRAY) {
                        for (LoaderValue element : required.asArray()) {
                            if (element.type() != LoaderValue.LType.STRING) continue;
                            if (!QuiltLoader.isModLoaded((String)element.asString())) continue block13;
                            requiredDeps.add(element.asString());
                        }
                    }
                }
                String id = Objects.requireNonNull(plugin.get((Object)"id")).asString();
                String initializer = Objects.requireNonNull(plugin.get((Object)"initializer")).asString();
                switch (sideStr = plugin.containsKey((Object)"environment") ? Objects.requireNonNull(plugin.get((Object)"environment")).asString() : "both") {
                    case "client": {
                        side = IPluginInfo.Side.CLIENT;
                        break;
                    }
                    case "server": {
                        side = IPluginInfo.Side.SERVER;
                        break;
                    }
                    case "both": {
                        side = IPluginInfo.Side.BOTH;
                        break;
                    }
                    default: {
                        Waila.LOGGER.error("Environment for plugin {} is not valid, must be one of [client, server, both].", (Object)id);
                        continue block13;
                    }
                }
                if (side == IPluginInfo.Side.CLIENT && MinecraftQuiltLoader.getEnvironmentType() != EnvType.CLIENT || side == IPluginInfo.Side.SERVER && MinecraftQuiltLoader.getEnvironmentType() != EnvType.SERVER) continue;
                PluginInfo.register(mod.metadata().id(), id, side, initializer, requiredDeps, true);
            }
        }
    }
}

