/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.gson.Gson;
import io.netty.buffer.Unpooled;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.C2SPacketReceiver;
import lol.bai.badpackets.api.S2CPacketReceiver;
import lol.bai.badpackets.api.event.PacketSenderReadyCallback;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.DataAccessor;
import mcp.mobius.waila.access.ServerAccessor;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.debug.DumpGenerator;
import mcp.mobius.waila.registry.Registrar;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class Packets {
    public static final class_2960 VERSION = Waila.id("version");
    public static final class_2960 ENTITY = Waila.id("entity");
    public static final class_2960 BLOCK = Waila.id("block");
    public static final class_2960 DATA = Waila.id("data");
    public static final class_2960 CONFIG = Waila.id("config");
    public static final class_2960 BLACKLIST = Waila.id("blacklist");
    public static final class_2960 GENERATE_CLIENT_DUMP = Waila.id("generate_client_dump");
    private static final Gson GSON = new Gson();

    public static void initServer() {
        PacketSenderReadyCallback.registerServer((handler, sender, server) -> {
            class_2540 versionBuf = new class_2540(Unpooled.buffer());
            versionBuf.method_10804(4);
            sender.send(VERSION, versionBuf);
            class_2540 blacklistBuf = new class_2540(Unpooled.buffer());
            BlacklistConfig blacklistConfig = Waila.BLACKLIST_CONFIG.get();
            Packets.writeIds(blacklistBuf, blacklistConfig.blockIds);
            Packets.writeIds(blacklistBuf, blacklistConfig.blockEntityTypeIds);
            Packets.writeIds(blacklistBuf, blacklistConfig.entityTypeIds);
            sender.send(BLACKLIST, blacklistBuf);
            class_2540 configBuf = new class_2540(Unpooled.buffer());
            Map<String, List<ConfigEntry>> groups = PluginConfig.getSyncableConfigs().stream().collect(Collectors.groupingBy(c -> c.getId().method_12836()));
            configBuf.method_10804(groups.size());
            groups.forEach((namespace, entries) -> {
                configBuf.method_10814(namespace);
                configBuf.method_10804(entries.size());
                entries.forEach(e -> {
                    configBuf.method_10814(e.getId().method_12832());
                    Object v = e.getLocalValue();
                    if (v instanceof Boolean) {
                        Boolean z = (Boolean)v;
                        configBuf.writeByte(0);
                        configBuf.writeBoolean(z.booleanValue());
                    } else if (v instanceof Integer) {
                        Integer i = (Integer)v;
                        configBuf.writeByte(1);
                        configBuf.method_10804(i.intValue());
                    } else if (v instanceof Double) {
                        Double d = (Double)v;
                        configBuf.writeByte(2);
                        configBuf.writeDouble(d.doubleValue());
                    } else if (v instanceof String) {
                        String str = (String)v;
                        configBuf.writeByte(3);
                        configBuf.method_10814(str);
                    } else if (v instanceof Enum) {
                        Enum en = (Enum)v;
                        configBuf.writeByte(3);
                        configBuf.method_10814(en.name());
                    }
                });
            });
            sender.send(CONFIG, configBuf);
        });
        C2SPacketReceiver.register((class_2960)VERSION, (server, player, handler, buf, responseSender) -> {
            int clientVersion = buf.method_10816();
            if (clientVersion != 4) {
                handler.method_14367((class_2561)class_2561.method_43470((String)("WTHIT network version mismatch! Server version is 4 while client version is " + clientVersion)));
            }
        });
        C2SPacketReceiver.register((class_2960)ENTITY, (server, player, handler, buf, responseSender) -> {
            int entityId = buf.method_10816();
            class_243 hitPos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            server.execute(() -> {
                Registrar registrar = Registrar.INSTANCE;
                class_1937 world = player.field_6002;
                class_1297 entity = world.method_8469(entityId);
                if (entity == null) {
                    return;
                }
                class_2487 data = new class_2487();
                IServerAccessor accessor = ServerAccessor.INSTANCE.set(world, player, (class_239)new class_3966(entity, hitPos), entity);
                for (IServerDataProvider<class_1297> provider : registrar.entityData.get(entity)) {
                    provider.appendServerData(data, accessor, PluginConfig.SERVER);
                }
                data.method_10569("WailaEntityID", entity.method_5628());
                data.method_10544("WailaTime", System.currentTimeMillis());
                class_2540 dataBuf = new class_2540(Unpooled.buffer());
                dataBuf.method_10794(data);
                responseSender.send(DATA, dataBuf);
            });
        });
        C2SPacketReceiver.register((class_2960)BLOCK, (server, player, handler, buf, responseSender) -> {
            class_3965 hitResult = buf.method_17814();
            server.execute(() -> {
                Registrar registrar = Registrar.INSTANCE;
                class_1937 world = player.field_6002;
                class_2338 pos = hitResult.method_17777();
                if (!world.method_22340(pos)) {
                    return;
                }
                class_2586 blockEntity = world.method_8321(pos);
                if (blockEntity == null) {
                    return;
                }
                class_2680 state = world.method_8320(pos);
                class_2487 data = new class_2487();
                IServerAccessor accessor = ServerAccessor.INSTANCE.set(world, player, (class_239)hitResult, blockEntity);
                for (IServerDataProvider<class_2586> provider : registrar.blockData.get(blockEntity)) {
                    provider.appendServerData(data, accessor, PluginConfig.SERVER);
                }
                for (IServerDataProvider<class_2586> provider : registrar.blockData.get(state.method_26204())) {
                    provider.appendServerData(data, accessor, PluginConfig.SERVER);
                }
                data.method_10569("x", pos.method_10263());
                data.method_10569("y", pos.method_10264());
                data.method_10569("z", pos.method_10260());
                data.method_10582("id", class_7923.field_41181.method_10221((Object)blockEntity.method_11017()).toString());
                data.method_10544("WailaTime", System.currentTimeMillis());
                class_2540 dataBuf = new class_2540(Unpooled.buffer());
                dataBuf.method_10794(data);
                responseSender.send(DATA, dataBuf);
            });
        });
    }

    public static void initClient() {
        PacketSenderReadyCallback.registerClient((handler, sender, client) -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10804(4);
            sender.send(VERSION, buf);
        });
        S2CPacketReceiver.register((class_2960)VERSION, (client, handler, buf, responseSender) -> {
            int serverVersion = buf.method_10816();
            if (serverVersion != 4) {
                handler.method_48296().method_10747((class_2561)class_2561.method_43470((String)("WTHIT network version mismatch! Server version is " + serverVersion + " while client version is 4")));
            }
        });
        S2CPacketReceiver.register((class_2960)DATA, (client, handler, buf, responseSender) -> {
            class_2487 data = buf.method_10798();
            client.execute(() -> DataAccessor.INSTANCE.setServerData(data));
        });
        S2CPacketReceiver.register((class_2960)CONFIG, (client, handler, buf, responseSender) -> {
            HashMap<class_2960, Object> map = new HashMap<class_2960, Object>();
            int groupSize = buf.method_10816();
            for (int i = 0; i < groupSize; ++i) {
                String namespace = buf.method_19772();
                int groupLen = buf.method_10816();
                block7: for (int j = 0; j < groupLen; ++j) {
                    class_2960 id = new class_2960(namespace, buf.method_19772());
                    byte type = buf.readByte();
                    switch (type) {
                        case 0: {
                            map.put(id, buf.readBoolean());
                            continue block7;
                        }
                        case 1: {
                            map.put(id, buf.method_10816());
                            continue block7;
                        }
                        case 2: {
                            map.put(id, buf.readDouble());
                            continue block7;
                        }
                        case 3: {
                            map.put(id, buf.method_19772());
                        }
                    }
                }
            }
            client.execute(() -> {
                for (ConfigEntry<Object> config : PluginConfig.getSyncableConfigs()) {
                    Object syncedValue;
                    class_2960 id = config.getId();
                    Object clientOnlyValue = config.getClientOnlyValue();
                    if (clientOnlyValue instanceof Enum) {
                        Enum e = (Enum)clientOnlyValue;
                        v0 = Enum.valueOf(e.getDeclaringClass(), map.getOrDefault(id, e.name()));
                    } else {
                        v0 = syncedValue = map.get(id);
                    }
                    if (syncedValue instanceof Double) {
                        Double d = (Double)syncedValue;
                        if (clientOnlyValue instanceof Integer) {
                            syncedValue = d.intValue();
                        }
                    }
                    config.setServerValue(syncedValue);
                }
                Waila.LOGGER.info("Received config from the server: {}", (Object)GSON.toJson((Object)map));
            });
        });
        S2CPacketReceiver.register((class_2960)BLACKLIST, (client, handler, buf, responseSender) -> {
            Set<class_2960> blockIds = Packets.readIds(buf);
            Set<class_2960> blockEntityIds = Packets.readIds(buf);
            Set<class_2960> entityIds = Packets.readIds(buf);
            client.execute(() -> {
                BlacklistConfig blacklist = Waila.BLACKLIST_CONFIG.get();
                Packets.setBlackList(blockIds, blacklist.blocks, class_7923.field_41175);
                Packets.setBlackList(blockEntityIds, blacklist.blockEntityTypes, class_7923.field_41181);
                Packets.setBlackList(entityIds, blacklist.entityTypes, class_7923.field_41177);
            });
        });
        S2CPacketReceiver.register((class_2960)GENERATE_CLIENT_DUMP, (client, handler, buf, responseSender) -> client.execute(() -> {
            Path path = DumpGenerator.generate("client_dump");
            if (path != null && client.field_1724 != null) {
                class_5250 pathComponent = class_2561.method_43470((String)path.toString()).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11746, path.toString())));
                client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"command.waila.client_dump_success", (Object[])new Object[]{pathComponent}), false);
            }
        }));
    }

    private static <T> void setBlackList(Set<class_2960> ids, Set<T> set, class_2378<T> registry) {
        for (class_2960 id : ids) {
            set.add(registry.method_10223(id));
        }
    }

    private static void writeIds(class_2540 buf, Set<class_2960> set) {
        Map<String, List<class_2960>> groups = set.stream().collect(Collectors.groupingBy(class_2960::method_12836));
        buf.method_10804(groups.size());
        groups.forEach((namespace, ids) -> {
            buf.method_10814(namespace);
            buf.method_10804(ids.size());
            ids.forEach(id -> buf.method_10814(id.method_12832()));
        });
    }

    private static Set<class_2960> readIds(class_2540 buf) {
        HashSet<class_2960> set = new HashSet<class_2960>();
        int groupSize = buf.method_10816();
        for (int i = 0; i < groupSize; ++i) {
            String namespace = buf.method_19772();
            int groupLen = buf.method_10816();
            for (int j = 0; j < groupLen; ++j) {
                set.add(new class_2960(namespace, buf.method_19772()));
            }
        }
        return set;
    }
}

