/*
 * Decompiled with CFR 0.152.
 */
package net.hypercubemc.iris_installer;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import net.fabricmc.installer.Main;
import net.fabricmc.installer.util.MetaHandler;
import net.fabricmc.installer.util.Reference;
import net.fabricmc.installer.util.Utils;
import net.hypercubemc.iris_installer.DarkModeDetector;
import net.hypercubemc.iris_installer.Downloader;
import net.hypercubemc.iris_installer.InstallerMeta;
import net.hypercubemc.iris_installer.VanillaLauncherIntegration;
import org.json.JSONException;

public class NewInstaller
extends JFrame {
    private static boolean dark = false;
    private boolean installAsMod;
    private String outdatedPlaceholder = "Warning: We have ended support for <version>.";
    private String snapshotPlaceholder = "Warning: <version> is a snapshot build and may";
    private String BASE_URL = "https://raw.githubusercontent.com/IrisShaders/Iris-Installer-Files/master/";
    private boolean finishedSuccessfulInstall;
    private InstallerMeta.Version selectedVersion;
    private final List<InstallerMeta.Version> GAME_VERSIONS;
    private final InstallerMeta INSTALLER_META;
    private Path customInstallDir;
    private JCheckBox betaSelection;
    private JButton directoryName;
    private JRadioButton fabricType;
    private JLabel gameVersionLabel;
    private JComboBox<String> gameVersionList;
    private JButton installButton;
    private ButtonGroup installType;
    private JLabel installationDirectory;
    private JLabel installationType;
    private JPanel installationTypesContainer;
    private JLabel irisInstallerLabel;
    private JLabel outdatedText1;
    private JLabel outdatedText2;
    private JProgressBar progressBar;
    private JRadioButton standaloneType;

    public NewInstaller() {
        super("Iris Installer");
        Main.LOADER_META = new MetaHandler(Reference.getMetaServerEndpoint("v2/versions/loader"));
        try {
            Main.LOADER_META.load();
        }
        catch (IOException e) {
            System.out.println("Failed to fetch fabric version info from the server!");
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "The installer was unable to fetch fabric version info from the server, please check your internet connection and try again later.", "Please check your internet connection!", 0);
            throw new RuntimeException(e);
        }
        this.INSTALLER_META = new InstallerMeta(this.BASE_URL + "meta-new.json");
        try {
            this.INSTALLER_META.load();
        }
        catch (IOException e) {
            System.out.println("Failed to fetch installer metadata from the server!");
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "The installer was unable to fetch metadata from the server, please check your internet connection and try again later.", "Please check your internet connection!", 0);
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            System.out.println("Failed to fetch installer metadata from the server!");
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Installer metadata parsing failed, please contact the Iris support team via Discord! \nError: " + e, "Metadata Parsing Failed!", 0);
            throw new RuntimeException(e);
        }
        this.GAME_VERSIONS = this.INSTALLER_META.getVersions();
        Collections.reverse(this.GAME_VERSIONS);
        this.selectedVersion = this.GAME_VERSIONS.get(0);
        this.initComponents();
        this.betaSelection.setText("Use " + this.INSTALLER_META.getBetaSnippet() + " beta version (not recommended)");
        if (!dark) {
            Color newTextColor = new Color(154, 136, 63, 255);
            this.outdatedText1.setForeground(newTextColor);
            this.outdatedText2.setForeground(newTextColor);
        }
        if (!this.INSTALLER_META.hasBeta()) {
            this.betaSelection.setVisible(false);
        }
        this.gameVersionList.removeAllItems();
        for (InstallerMeta.Version version : this.GAME_VERSIONS) {
            this.gameVersionList.addItem(version.name);
        }
        this.directoryName.setText(this.getDefaultInstallDir().toFile().getName());
        this.outdatedText1.setVisible(false);
        this.outdatedText2.setVisible(false);
    }

    public Path getStorageDirectory() {
        return this.getAppDataDirectory().resolve(this.getStorageDirectoryName());
    }

    public Path getInstallDir() {
        return this.customInstallDir != null ? this.customInstallDir : this.getDefaultInstallDir();
    }

    public Path getAppDataDirectory() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return new File(System.getenv("APPDATA")).toPath();
        }
        if (os.contains("mac")) {
            return new File(System.getProperty("user.home") + "/Library/Application Support").toPath();
        }
        if (os.contains("nux")) {
            return new File(System.getProperty("user.home")).toPath();
        }
        return new File(System.getProperty("user.dir")).toPath();
    }

    public String getStorageDirectoryName() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("mac")) {
            return "iris-installer";
        }
        return ".iris-installer";
    }

    private Path getDefaultInstallDir() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("mac")) {
            return this.getAppDataDirectory().resolve("minecraft");
        }
        return this.getAppDataDirectory().resolve(".minecraft");
    }

    public Path getVanillaGameDir() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("mac") ? this.getAppDataDirectory().resolve("minecraft") : this.getAppDataDirectory().resolve(".minecraft");
    }

    public boolean installFromZip(File zip) {
        try {
            int BUFFER_SIZE = 2048;
            try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zip));){
                ZipEntry entry = zipIn.getNextEntry();
                if (!this.installAsMod) {
                    this.getInstallDir().resolve("iris-reserved/").toFile().mkdir();
                }
                while (entry != null) {
                    String entryName = entry.getName();
                    if (!this.installAsMod && entryName.startsWith("mods/")) {
                        entryName = entryName.replace("mods/", "iris-reserved/" + this.selectedVersion + "/");
                    }
                    File filePath = this.getInstallDir().resolve(entryName).toFile();
                    if (!entry.isDirectory()) {
                        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
                            byte[] bytesIn = new byte[BUFFER_SIZE];
                            int read = 0;
                            while ((read = zipIn.read(bytesIn)) != -1) {
                                bos.write(bytesIn, 0, read);
                            }
                        }
                    } else {
                        filePath.mkdir();
                    }
                    zipIn.closeEntry();
                    entry = zipIn.getNextEntry();
                }
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void initComponents() {
        this.installType = new ButtonGroup();
        this.irisInstallerLabel = new JLabel();
        this.gameVersionLabel = new JLabel();
        this.outdatedText1 = new JLabel();
        this.outdatedText2 = new JLabel();
        this.installationType = new JLabel();
        this.installationDirectory = new JLabel();
        this.installationTypesContainer = new JPanel();
        this.standaloneType = new JRadioButton();
        this.fabricType = new JRadioButton();
        this.gameVersionList = new JComboBox();
        this.betaSelection = new JCheckBox();
        this.directoryName = new JButton();
        this.progressBar = new JProgressBar();
        this.installButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.setIconImage(new ImageIcon(Objects.requireNonNull(Utils.class.getClassLoader().getResource("iris_profile_icon.png"))).getImage());
        this.setMaximumSize(new Dimension(480, 600));
        this.setMinimumSize(new Dimension(480, 600));
        this.setPreferredSize(new Dimension(480, 600));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.irisInstallerLabel.setFont(this.irisInstallerLabel.getFont().deriveFont(36.0f));
        this.irisInstallerLabel.setHorizontalAlignment(0);
        this.irisInstallerLabel.setIcon(new ImageIcon(this.getClass().getResource("/iris_profile_icon.png")));
        this.irisInstallerLabel.setText(" Iris & Sodium");
        this.irisInstallerLabel.setMaximumSize(new Dimension(350, 64));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        this.getContentPane().add((Component)this.irisInstallerLabel, gridBagConstraints);
        this.gameVersionLabel.setFont(this.gameVersionLabel.getFont().deriveFont(this.gameVersionLabel.getFont().getStyle() | 1, 16.0f));
        this.gameVersionLabel.setHorizontalAlignment(0);
        this.gameVersionLabel.setText("Select game version:");
        this.gameVersionLabel.setToolTipText("");
        this.gameVersionLabel.setHorizontalTextPosition(0);
        this.gameVersionLabel.setMaximumSize(new Dimension(300, 24));
        this.gameVersionLabel.setMinimumSize(new Dimension(168, 24));
        this.gameVersionLabel.setPreferredSize(new Dimension(168, 24));
        this.gameVersionLabel.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.getContentPane().add((Component)this.gameVersionLabel, gridBagConstraints);
        this.outdatedText1.setFont(this.outdatedText1.getFont().deriveFont(16.0f));
        this.outdatedText1.setForeground(new Color(255, 204, 0));
        this.outdatedText1.setHorizontalAlignment(0);
        this.outdatedText1.setText("Warning: We have ended support for <version>.");
        this.outdatedText1.setHorizontalTextPosition(0);
        this.outdatedText1.setMaximumSize(new Dimension(400, 21));
        this.outdatedText1.setMinimumSize(new Dimension(310, 21));
        this.outdatedText1.setPreferredSize(new Dimension(310, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.getContentPane().add((Component)this.outdatedText1, gridBagConstraints);
        this.outdatedText2.setFont(this.outdatedText2.getFont().deriveFont(16.0f));
        this.outdatedText2.setForeground(new Color(255, 204, 0));
        this.outdatedText2.setHorizontalAlignment(0);
        this.outdatedText2.setText("The Iris version you get will most likely be outdated.");
        this.outdatedText2.setHorizontalTextPosition(0);
        this.outdatedText2.setMaximumSize(new Dimension(450, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.outdatedText2, gridBagConstraints);
        this.installationType.setFont(this.installationType.getFont().deriveFont(this.installationType.getFont().getStyle() | 1, 16.0f));
        this.installationType.setHorizontalAlignment(0);
        this.installationType.setText(" Installation type:");
        this.installationType.setHorizontalTextPosition(0);
        this.installationType.setMaximumSize(new Dimension(300, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.getContentPane().add((Component)this.installationType, gridBagConstraints);
        this.installationDirectory.setFont(this.installationDirectory.getFont().deriveFont(this.installationDirectory.getFont().getStyle() | 1, 16.0f));
        this.installationDirectory.setHorizontalAlignment(0);
        this.installationDirectory.setText("Installation directory:");
        this.installationDirectory.setHorizontalTextPosition(0);
        this.installationDirectory.setMaximumSize(new Dimension(300, 24));
        this.installationDirectory.setMinimumSize(new Dimension(165, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.getContentPane().add((Component)this.installationDirectory, gridBagConstraints);
        this.installationTypesContainer.setLayout(new BorderLayout(10, 0));
        this.installType.add(this.standaloneType);
        this.standaloneType.setFont(this.standaloneType.getFont().deriveFont(16.0f));
        this.standaloneType.setSelected(true);
        this.standaloneType.setText("Iris Install");
        this.standaloneType.setToolTipText("This installs Iris and Sodium by itself, without any mods.");
        this.standaloneType.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewInstaller.this.standaloneTypeMouseClicked(evt);
            }
        });
        this.installationTypesContainer.add((Component)this.standaloneType, "Before");
        this.installType.add(this.fabricType);
        this.fabricType.setFont(this.fabricType.getFont().deriveFont(16.0f));
        this.fabricType.setText("Fabric Install");
        this.fabricType.setToolTipText("This installs Iris and Sodium alongside an installation of Fabric.");
        this.fabricType.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewInstaller.this.fabricTypeMouseClicked(evt);
            }
        });
        this.installationTypesContainer.add((Component)this.fabricType, "After");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.getContentPane().add((Component)this.installationTypesContainer, gridBagConstraints);
        this.gameVersionList.setFont(new Font("Arial", 0, 14));
        this.gameVersionList.setModel(new DefaultComboBoxModel<String>(new String[]{"1.19", "1.18.2", "1.17.1", "1.16.5"}));
        this.gameVersionList.setMaximumSize(new Dimension(168, 35));
        this.gameVersionList.setMinimumSize(new Dimension(168, 35));
        this.gameVersionList.setPreferredSize(new Dimension(168, 35));
        this.gameVersionList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NewInstaller.this.gameVersionListItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.getContentPane().add(this.gameVersionList, gridBagConstraints);
        this.betaSelection.setFont(this.betaSelection.getFont().deriveFont(16.0f));
        this.betaSelection.setText("Use beta version (not recommended)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.getContentPane().add((Component)this.betaSelection, gridBagConstraints);
        this.directoryName.setFont(this.directoryName.getFont().deriveFont(16.0f));
        this.directoryName.setLabel("Directory Name");
        this.directoryName.setMaximumSize(new Dimension(300, 36));
        this.directoryName.setMinimumSize(new Dimension(300, 36));
        this.directoryName.setPreferredSize(new Dimension(300, 36));
        this.directoryName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewInstaller.this.directoryNameMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.getContentPane().add((Component)this.directoryName, gridBagConstraints);
        this.progressBar.setFont(this.progressBar.getFont().deriveFont(16.0f));
        this.progressBar.setAlignmentX(0.0f);
        this.progressBar.setAlignmentY(0.0f);
        this.progressBar.setMaximumSize(new Dimension(380, 25));
        this.progressBar.setMinimumSize(new Dimension(380, 25));
        this.progressBar.setPreferredSize(new Dimension(380, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(40, 0, 0, 0);
        this.getContentPane().add((Component)this.progressBar, gridBagConstraints);
        this.installButton.setFont(this.installButton.getFont().deriveFont(16.0f));
        this.installButton.setText("Install");
        this.installButton.setToolTipText("");
        this.installButton.setMargin(new Insets(10, 70, 10, 70));
        this.installButton.setMaximumSize(new Dimension(320, 45));
        this.installButton.setMinimumSize(new Dimension(173, 45));
        this.installButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewInstaller.this.installButtonMouseClicked(evt);
            }
        });
        this.installButton.putClientProperty("JButton.buttonType", "roundRect");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(12, 0, 30, 0);
        this.getContentPane().add((Component)this.installButton, gridBagConstraints);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void directoryNameMouseClicked(MouseEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setFileHidingEnabled(false);
        int option = fileChooser.showOpenDialog(this);
        if (option == 0) {
            File file = fileChooser.getSelectedFile();
            this.customInstallDir = file.toPath();
            this.directoryName.setText(file.getName());
        }
    }

    private void gameVersionListItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.selectedVersion = this.GAME_VERSIONS.stream().filter(v -> v.name.equals(evt.getItem())).findFirst().orElse(this.GAME_VERSIONS.get(0));
            if (this.selectedVersion.outdated) {
                this.outdatedText1.setText(this.outdatedPlaceholder.replace("<version>", this.selectedVersion.name));
                this.betaSelection.setVisible(false);
                this.outdatedText1.setVisible(true);
                this.outdatedText2.setText("The Iris version you get will most likely be outdated.");
                this.outdatedText2.setVisible(true);
            } else if (this.selectedVersion.snapshot) {
                this.outdatedText1.setText(this.snapshotPlaceholder.replace("<version>", this.selectedVersion.name));
                this.betaSelection.setVisible(false);
                this.outdatedText1.setVisible(true);
                this.outdatedText2.setText("lose support at any time.");
                this.outdatedText2.setVisible(true);
            } else {
                if (this.INSTALLER_META.hasBeta()) {
                    this.betaSelection.setVisible(true);
                }
                this.outdatedText1.setVisible(false);
                this.outdatedText2.setVisible(false);
            }
        }
    }

    private void standaloneTypeMouseClicked(MouseEvent evt) {
        this.installAsMod = false;
    }

    private void fabricTypeMouseClicked(MouseEvent evt) {
        this.installAsMod = true;
    }

    private void installButtonMouseClicked(MouseEvent evt) {
        String loaderName = this.installAsMod ? "fabric-loader" : "iris-fabric-loader";
        try {
            URL loaderVersionUrl = new URL("https://raw.githubusercontent.com/IrisShaders/Iris-Installer-Maven/master/latest-loader");
            String profileName = this.installAsMod ? "Fabric Loader " : "Iris & Sodium for ";
            VanillaLauncherIntegration.Icon profileIcon = this.installAsMod ? VanillaLauncherIntegration.Icon.FABRIC : VanillaLauncherIntegration.Icon.IRIS;
            String loaderVersion = this.installAsMod ? Main.LOADER_META.getLatestVersion(false).getVersion() : Utils.readTextFile(loaderVersionUrl);
            boolean success = VanillaLauncherIntegration.installToLauncher(this, this.getVanillaGameDir(), this.getInstallDir(), profileName + this.selectedVersion.name, this.selectedVersion.name, loaderName, loaderVersion, profileIcon);
            if (!success) {
                System.out.println("Failed to install to launcher, canceling!");
                return;
            }
        }
        catch (IOException e) {
            System.out.println("Failed to install version and profile to vanilla launcher!");
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Failed to install to vanilla launcher, please contact the Iris support team via Discord! \nError: " + e, "Failed to install to launcher", 0);
            return;
        }
        File storageDir = this.getStorageDirectory().toFile();
        if (!storageDir.exists() || !storageDir.isDirectory()) {
            storageDir.mkdir();
        }
        this.installButton.setText("Downloading...");
        this.installButton.setEnabled(false);
        this.progressBar.setForeground(new Color(76, 135, 200));
        this.progressBar.setValue(0);
        String zipName = (this.betaSelection.isSelected() ? "Iris-Sodium-Beta" : "Iris-Sodium") + "-" + this.selectedVersion.name + ".zip";
        String downloadURL = "https://github.com/IrisShaders/Iris-Installer-Files/releases/latest/download/" + zipName;
        File saveLocation = this.getStorageDirectory().resolve(zipName).toFile();
        Downloader downloader = new Downloader(downloadURL, saveLocation);
        downloader.addPropertyChangeListener(event -> {
            if ("progress".equals(event.getPropertyName())) {
                this.progressBar.setValue((Integer)event.getNewValue());
            } else if (event.getNewValue() == SwingWorker.StateValue.DONE) {
                boolean installSuccess;
                File modsFolder;
                File[] modsFolderContents;
                try {
                    downloader.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    System.out.println("Failed to download zip!");
                    e.getCause().printStackTrace();
                    String msg = String.format("An error occurred while attempting to download the required files, please check your internet connection and try again! \nError: %s", e.getCause().toString());
                    this.installButton.setEnabled(true);
                    this.installButton.setText("Download Failed!");
                    this.progressBar.setForeground(new Color(204, 0, 0));
                    this.progressBar.setValue(100);
                    JOptionPane.showMessageDialog(this, msg, "Download Failed!", 0, null);
                    return;
                }
                this.installButton.setText("Download Complete!");
                boolean cancelled = false;
                File installDir = this.getInstallDir().toFile();
                if (!installDir.exists() || !installDir.isDirectory()) {
                    installDir.mkdir();
                }
                if ((modsFolderContents = (modsFolder = this.installAsMod ? this.getInstallDir().resolve("mods").toFile() : this.getInstallDir().resolve("iris-reserved").resolve(this.selectedVersion.name).toFile()).listFiles()) != null) {
                    int result;
                    boolean isEmpty;
                    boolean bl = isEmpty = modsFolderContents.length == 0;
                    if (this.installAsMod && modsFolder.exists() && modsFolder.isDirectory() && !isEmpty && (result = JOptionPane.showConfirmDialog(this, "An existing mods folder was found in the selected game directory. Do you want to update/install iris?", "Mods Folder Detected", 0, 3)) != 0) {
                        cancelled = true;
                    }
                    if (!cancelled) {
                        boolean shownOptifineDialog = false;
                        boolean failedToRemoveOptifine = false;
                        File[] fileArray = modsFolderContents;
                        int n = fileArray.length;
                        for (int i = 0; i < n; ++i) {
                            File mod = fileArray[i];
                            if (!mod.getName().toLowerCase().contains("optifine") && !mod.getName().toLowerCase().contains("optifabric")) continue;
                            if (!shownOptifineDialog) {
                                int result2 = JOptionPane.showOptionDialog(this, "Optifine was found in your mods folder, but Optifine is incompatible with Iris. Do you want to remove it, or cancel the installation?", "Optifine Detected", -1, 2, null, new String[]{"Yes", "Cancel"}, "Yes");
                                shownOptifineDialog = true;
                                if (result2 != 0) {
                                    cancelled = true;
                                    break;
                                }
                            }
                            if (mod.delete()) continue;
                            failedToRemoveOptifine = true;
                        }
                        if (failedToRemoveOptifine) {
                            System.out.println("Failed to delete optifine from mods folder");
                            JOptionPane.showMessageDialog(this, "Failed to remove optifine from your mods folder, please make sure your game is closed and try again!", "Failed to remove optifine", 0);
                            cancelled = true;
                        }
                    }
                    if (!cancelled) {
                        boolean failedToRemoveIrisOrSodium = false;
                        for (File mod : modsFolderContents) {
                            if (!mod.getName().toLowerCase().contains("iris") && !mod.getName().toLowerCase().contains("sodium-fabric") || mod.delete()) continue;
                            failedToRemoveIrisOrSodium = true;
                        }
                        if (failedToRemoveIrisOrSodium) {
                            System.out.println("Failed to remove Iris or Sodium from mods folder to update them!");
                            JOptionPane.showMessageDialog(this, "Failed to remove iris and sodium from your mods folder to update them, please make sure your game is closed and try again!", "Failed to prepare mods for update", 0);
                            cancelled = true;
                        }
                    }
                }
                if (cancelled) {
                    this.installButton.setEnabled(true);
                    return;
                }
                if (!modsFolder.exists() || !modsFolder.isDirectory()) {
                    modsFolder.mkdir();
                }
                if (installSuccess = this.installFromZip(saveLocation)) {
                    this.installButton.setText("Completed!");
                    this.progressBar.setForeground(new Color(39, 195, 75));
                    this.installButton.setEnabled(true);
                    this.finishedSuccessfulInstall = true;
                } else {
                    this.installButton.setText("Failed!");
                    this.progressBar.setForeground(new Color(204, 0, 0));
                    System.out.println("Failed to install to mods folder!");
                    JOptionPane.showMessageDialog(this, "Failed to install to mods folder, please make sure your game is closed and try again!", "Installation Failed!", 0);
                }
            }
        });
        downloader.execute();
    }

    public static void main(String[] args) {
        dark = DarkModeDetector.isDarkMode();
        System.setProperty("apple.awt.application.appearance", "system");
        if (dark) {
            FlatDarkLaf.setup();
        } else {
            FlatLightLaf.setup();
        }
        System.out.println("Launching installer...");
        EventQueue.invokeLater(() -> new NewInstaller().setVisible(true));
    }
}

