/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class Utils {
    public static final DateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle("lang/installer", Locale.getDefault(), new ResourceBundle.Control(){

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            block11: {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, "properties");
                try (InputStream stream = loader.getResourceAsStream(resourceName);){
                    PropertyResourceBundle propertyResourceBundle;
                    if (stream == null) break block11;
                    try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                        propertyResourceBundle = new PropertyResourceBundle(reader);
                    }
                    return propertyResourceBundle;
                }
            }
            return super.newBundle(baseName, locale, format, loader, reload);
        }
    });

    public static Path findDefaultInstallDir() {
        Path dir;
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (os.contains("win") && System.getenv("APPDATA") != null) {
            dir = Paths.get(System.getenv("APPDATA"), new String[0]).resolve(".minecraft");
        } else {
            String home = System.getProperty("user.home", ".");
            Path homeDir = Paths.get(home, new String[0]);
            dir = os.contains("mac") ? homeDir.resolve("Library").resolve("Application Support").resolve("minecraft") : homeDir.resolve(".minecraft");
        }
        return dir.toAbsolutePath().normalize();
    }

    public static Reader urlReader(URL url) throws IOException {
        return new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
    }

    public static String readTextFile(URL url) throws IOException {
        try (BufferedReader reader = new BufferedReader(Utils.urlReader(url));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    public static String readString(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }

    public static String readString(InputStream is) throws IOException {
        int len;
        byte[] data = new byte[Math.max(1000, is.available())];
        int offset = 0;
        while ((len = is.read(data, offset, data.length - offset)) >= 0) {
            if ((offset += len) != data.length) continue;
            int next = is.read();
            if (next < 0) break;
            data = Arrays.copyOf(data, data.length * 2);
            data[offset++] = (byte)next;
        }
        return new String(data, 0, offset, StandardCharsets.UTF_8);
    }

    public static void writeToFile(Path path, String string) throws IOException {
        Files.write(path, string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static void downloadFile(URL url, Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (InputStream in = url.openStream();){
            Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static String getProfileIcon() {
        String string;
        block9: {
            InputStream is = Utils.class.getClassLoader().getResourceAsStream("profile_icon.png");
            try {
                int len;
                byte[] ret = new byte[4096];
                int offset = 0;
                while ((len = is.read(ret, offset, ret.length - offset)) != -1) {
                    if ((offset += len) != ret.length) continue;
                    ret = Arrays.copyOf(ret, ret.length * 2);
                }
                string = "data:image/png;base64," + Base64.getEncoder().encodeToString(Arrays.copyOf(ret, offset));
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return "TNT";
                }
            }
            is.close();
        }
        return string;
    }

    public static String sha1String(Path path) throws IOException {
        return Utils.bytesToHex(Utils.sha1(path));
    }

    public static byte[] sha1(Path path) throws IOException {
        MessageDigest digest = Utils.sha1Digest();
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            int len;
            byte[] buffer = new byte[65536];
            while ((len = is.read(buffer)) >= 0) {
                digest.update(buffer, 0, len);
            }
        }
        return digest.digest();
    }

    private static MessageDigest sha1Digest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Something has gone really wrong", e);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder output = new StringBuilder();
        for (byte b : bytes) {
            output.append(String.format("%02x", b));
        }
        return output.toString();
    }
}

