/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mjson.Json;
import net.fabricmc.installer.util.Reference;
import net.fabricmc.installer.util.Utils;
import net.fabricmc.installer.util.VersionMeta;

public class LauncherMeta {
    private static LauncherMeta launcherMeta = null;
    public final List<Version> versions;

    public static LauncherMeta getLauncherMeta() throws IOException {
        if (launcherMeta == null) {
            launcherMeta = LauncherMeta.load();
        }
        return launcherMeta;
    }

    private static LauncherMeta load() throws IOException {
        ArrayList<Version> versions = new ArrayList<Version>();
        versions.addAll(LauncherMeta.getVersionsFromUrl(Reference.minecraftLauncherManifest));
        versions.addAll(LauncherMeta.getVersionsFromUrl(Reference.experimentalVersionsManifest));
        return new LauncherMeta(versions);
    }

    private static List<Version> getVersionsFromUrl(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        String str = Utils.readTextFile(url);
        Json json = Json.read(str);
        List<Version> versions = json.at("versions").asJsonList().stream().map(Version::new).collect(Collectors.toList());
        return versions;
    }

    public LauncherMeta(List<Version> versions) {
        this.versions = versions;
    }

    public Version getVersion(String version) {
        return this.versions.stream().filter(v -> v.id.equals(version)).findFirst().orElse(null);
    }

    public static class Version {
        public final String id;
        public final String url;
        private VersionMeta versionMeta = null;

        public Version(Json json) {
            this.id = json.at("id").asString();
            this.url = json.at("url").asString();
        }

        public VersionMeta getVersionMeta() throws IOException {
            if (this.versionMeta == null) {
                URL url = new URL(this.url);
                String str = Utils.readTextFile(url);
                Json json = Json.read(str);
                this.versionMeta = new VersionMeta(json);
            }
            return this.versionMeta;
        }
    }
}

