/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import mjson.Json;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.LoaderVersion;
import net.fabricmc.installer.Main;
import net.fabricmc.installer.util.ArgumentParser;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.MetaHandler;
import net.fabricmc.installer.util.Utils;

public abstract class Handler
implements InstallerProgress {
    private static final String SELECT_CUSTOM_ITEM = "(select custom)";
    public JButton buttonInstall;
    public JComboBox<String> gameVersionComboBox;
    private JComboBox<String> loaderVersionComboBox;
    public JTextField installLocation;
    public JButton selectFolderButton;
    public JLabel statusLabel;
    public JCheckBox snapshotCheckBox;
    private JPanel pane;

    public abstract String name();

    public abstract void install();

    public abstract void installCli(ArgumentParser var1) throws Exception;

    public abstract String cliHelp();

    public abstract void setupPane1(JPanel var1, InstallerGui var2);

    public abstract void setupPane2(JPanel var1, InstallerGui var2);

    public JPanel makePanel(InstallerGui installerGui) {
        this.pane = new JPanel();
        this.pane.setLayout(new BoxLayout(this.pane, 3));
        this.setupPane1(this.pane, installerGui);
        this.addRow(this.pane, jPanel -> {
            jPanel.add(new JLabel(Utils.BUNDLE.getString("prompt.game.version")));
            this.gameVersionComboBox = new JComboBox();
            jPanel.add(this.gameVersionComboBox);
            this.snapshotCheckBox = new JCheckBox(Utils.BUNDLE.getString("option.show.snapshots"));
            jPanel.add(this.snapshotCheckBox);
            this.snapshotCheckBox.setSelected(false);
            this.snapshotCheckBox.addActionListener(e -> {
                if (Main.GAME_VERSION_META.isComplete()) {
                    this.updateGameVersions();
                }
            });
        });
        Main.GAME_VERSION_META.onComplete(versions -> this.updateGameVersions());
        this.addRow(this.pane, jPanel -> {
            jPanel.add(new JLabel(Utils.BUNDLE.getString("prompt.loader.version")));
            this.loaderVersionComboBox = new JComboBox();
            jPanel.add(this.loaderVersionComboBox);
        });
        this.addRow(this.pane, jPanel -> {
            jPanel.add(new JLabel(Utils.BUNDLE.getString("prompt.select.location")));
            this.installLocation = new JTextField();
            jPanel.add(this.installLocation);
            this.selectFolderButton = new JButton();
            jPanel.add(this.selectFolderButton);
            this.selectFolderButton.setText("...");
            this.selectFolderButton.addActionListener(e -> InstallerGui.selectInstallLocation(() -> this.installLocation.getText(), s -> this.installLocation.setText((String)s)));
        });
        this.setupPane2(this.pane, installerGui);
        this.addRow(this.pane, jPanel -> {
            this.statusLabel = new JLabel();
            jPanel.add(this.statusLabel);
            this.statusLabel.setText(Utils.BUNDLE.getString("prompt.loading.versions"));
        });
        this.addRow(this.pane, jPanel -> {
            this.buttonInstall = new JButton(Utils.BUNDLE.getString("prompt.install"));
            jPanel.add(this.buttonInstall);
            this.buttonInstall.addActionListener(e -> {
                this.buttonInstall.setEnabled(false);
                this.install();
            });
        });
        Main.LOADER_META.onComplete(versions -> {
            int stableIndex = -1;
            for (int i = 0; i < versions.size(); ++i) {
                MetaHandler.GameVersion version = (MetaHandler.GameVersion)versions.get(i);
                this.loaderVersionComboBox.addItem(version.getVersion());
                if (!version.isStable()) continue;
                stableIndex = i;
            }
            this.loaderVersionComboBox.addItem(SELECT_CUSTOM_ITEM);
            if (stableIndex == -1) {
                stableIndex = 0;
            }
            this.loaderVersionComboBox.setSelectedIndex(stableIndex);
            this.statusLabel.setText(Utils.BUNDLE.getString("prompt.ready.install"));
        });
        return this.pane;
    }

    private void updateGameVersions() {
        this.gameVersionComboBox.removeAllItems();
        for (MetaHandler.GameVersion version : Main.GAME_VERSION_META.getVersions()) {
            if (!this.snapshotCheckBox.isSelected() && !version.isStable()) continue;
            this.gameVersionComboBox.addItem(version.getVersion());
        }
        this.gameVersionComboBox.setSelectedIndex(0);
    }

    protected LoaderVersion queryLoaderVersion() {
        LoaderVersion loaderVersion;
        String ret = (String)this.loaderVersionComboBox.getSelectedItem();
        if (!ret.equals(SELECT_CUSTOM_ITEM)) {
            return new LoaderVersion(ret);
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        chooser.setDialogTitle("Select Fabric Loader JAR");
        chooser.setFileFilter(new FileNameExtensionFilter("Java Archive", "jar"));
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(null) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        ZipFile zf = new ZipFile(file);
        try {
            String modJsonContent;
            ZipEntry entry = zf.getEntry("fabric.mod.json");
            if (entry == null) {
                throw new FileNotFoundException("fabric.mod.json");
            }
            try (InputStream is = zf.getInputStream(entry);){
                modJsonContent = Utils.readString(is);
            }
            String version = Json.read(modJsonContent).at("version").asString();
            loaderVersion = new LoaderVersion(version, file.toPath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    zf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.error(e);
                return null;
            }
        }
        zf.close();
        return loaderVersion;
    }

    @Override
    public void updateProgress(String text) {
        this.statusLabel.setText(text);
        this.statusLabel.setForeground(UIManager.getColor("Label.foreground"));
    }

    protected String buildEditorPaneStyle() {
        JLabel label = new JLabel();
        Font font = label.getFont();
        Color color = label.getBackground();
        return String.format("font-family:%s;font-weight:%s;font-size:%dpt;background-color: rgb(%d,%d,%d);", font.getFamily(), font.isBold() ? "bold" : "normal", font.getSize(), color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public void error(Throwable throwable) {
        StringWriter sw = new StringWriter(800);
        try (PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
        }
        String st = sw.toString().trim();
        System.err.println(st);
        String html = String.format("<html><body style=\"%s\">%s</body></html>", this.buildEditorPaneStyle(), st.replace(System.lineSeparator(), "<br>").replace("\t", "&ensp;"));
        JEditorPane textPane = new JEditorPane("text/html", html);
        textPane.setEditable(false);
        this.statusLabel.setText(throwable.getLocalizedMessage());
        this.statusLabel.setForeground(Color.RED);
        JOptionPane.showMessageDialog(this.pane, textPane, Utils.BUNDLE.getString("prompt.exception.occurrence"), 0);
    }

    protected void addRow(Container parent, Consumer<JPanel> consumer) {
        JPanel panel = new JPanel(new FlowLayout());
        consumer.accept(panel);
        parent.add(panel);
    }

    protected String getGameVersion(ArgumentParser args) {
        return args.getOrDefault("mcversion", () -> {
            System.out.println("Using latest game version");
            try {
                Main.GAME_VERSION_META.load();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load latest versions", e);
            }
            return Main.GAME_VERSION_META.getLatestVersion(args.has("snapshot")).getVersion();
        });
    }

    protected String getLoaderVersion(ArgumentParser args) {
        return args.getOrDefault("loader", () -> {
            System.out.println("Using latest loader version");
            try {
                Main.LOADER_META.load();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load latest versions", e);
            }
            return Main.LOADER_META.getLatestVersion(false).getVersion();
        });
    }
}

