/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.minecraft.class_3532;
import org.apache.commons.lang3.Validate;

public class BoxBlur {
    public static void blur(ColorBuffer buffer, int radius) {
        if (buffer.isHomogenous()) {
            return;
        }
        ColorBuffer tmp = new ColorBuffer(buffer.width, buffer.height);
        BoxBlur.blur(buffer, tmp, radius);
        BoxBlur.blur(tmp, buffer, radius);
    }

    private static void blur(ColorBuffer src, ColorBuffer dst, int radius) {
        Validate.isTrue((src.width == dst.width ? 1 : 0) != 0);
        Validate.isTrue((src.height == dst.height ? 1 : 0) != 0);
        int multiplier = BoxBlur.getAveragingMultiplier(radius * 2 + 1);
        int width = src.width;
        int height = src.height;
        for (int y = 0; y < height; ++y) {
            int x;
            int srcRowOffset = src.getIndex(0, y);
            int red = src.getRed(srcRowOffset);
            int green = src.getGreen(srcRowOffset);
            int blue = src.getBlue(srcRowOffset);
            red += red * radius;
            green += green * radius;
            blue += blue * radius;
            for (x = 1; x <= radius; ++x) {
                red += src.getRed(srcRowOffset + x);
                green += src.getGreen(srcRowOffset + x);
                blue += src.getBlue(srcRowOffset + x);
            }
            for (x = 0; x < width; ++x) {
                dst.setARGB(dst.getIndex(y, x), BoxBlur.averageRGB(red, green, blue, multiplier));
                int prevX = Math.max(0, x - radius);
                red -= src.getRed(srcRowOffset + prevX);
                green -= src.getGreen(srcRowOffset + prevX);
                blue -= src.getBlue(srcRowOffset + prevX);
                int nextX = Math.min(width - 1, x + radius + 1);
                red += src.getRed(srcRowOffset + nextX);
                green += src.getGreen(srcRowOffset + nextX);
                blue += src.getBlue(srcRowOffset + nextX);
            }
        }
    }

    private static int getAveragingMultiplier(int size) {
        return class_3532.method_15384((double)(1.6777216E7 / (double)size));
    }

    public static int averageRGB(int red, int green, int blue, int multiplier) {
        int value = -16777216;
        value |= blue * multiplier >>> 24 << 0;
        value |= green * multiplier >>> 24 << 8;
        return value |= red * multiplier >>> 24 << 16;
    }

    public static class ColorBuffer {
        private final int[] data;
        private final int width;
        private final int height;

        public ColorBuffer(int width, int height) {
            this.data = new int[width * height];
            this.width = width;
            this.height = height;
        }

        public int getIndex(int x, int y) {
            return y * this.width + x;
        }

        public void setARGB(int index, int packed) {
            this.data[index] = packed;
        }

        public int getARGB(int index) {
            return this.data[index];
        }

        public int getRed(int index) {
            return ColorARGB.unpackRed(this.getARGB(index));
        }

        public int getGreen(int index) {
            return ColorARGB.unpackGreen(this.getARGB(index));
        }

        public int getBlue(int index) {
            return ColorARGB.unpackBlue(this.getARGB(index));
        }

        public boolean isHomogenous() {
            int[] data = this.data;
            int first = data[0];
            for (int i = 1; i < data.length; ++i) {
                if (data[i] == first) continue;
                return false;
            }
            return true;
        }
    }
}

