/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import me.jellysquid.mods.sodium.client.render.chunk.ColorResolverType;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.biome.BoxBlur;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_6539;

public class BiomeColorCache {
    private final WorldSlice slice;
    private final CachedColorBuffers[] cachedColorBuffers;
    private final int worldX;
    private final int worldZ;
    public final int radius;
    public final int inset;
    public final int size;

    public BiomeColorCache(WorldSlice slice, int radius) {
        this.slice = slice;
        this.radius = radius;
        int margin = class_3532.method_15340((int)this.radius, (int)3, (int)15);
        this.size = 16 + margin * 2;
        this.inset = 16 - margin;
        this.cachedColorBuffers = new CachedColorBuffers[this.size];
        class_4076 origin = slice.getOrigin();
        this.worldX = origin.method_19527() - margin;
        this.worldZ = origin.method_19529() - margin;
    }

    public int getColor(class_6539 resolver, int blockX, int blockY, int blockZ) {
        int x = class_3532.method_15340((int)(blockX - this.inset), (int)0, (int)(this.size - 1));
        int y = class_3532.method_15340((int)(blockY - this.inset), (int)0, (int)(this.size - 1));
        int z = class_3532.method_15340((int)(blockZ - this.inset), (int)0, (int)(this.size - 1));
        CachedColorBuffers buffers = this.cachedColorBuffers[y];
        if (buffers == null) {
            this.cachedColorBuffers[y] = buffers = this.createColorBuffers(y);
        }
        return buffers.get(ColorResolverType.get(resolver), x, z);
    }

    private CachedColorBuffers createColorBuffers(int y) {
        BoxBlur.ColorBuffer[] buffers = new BoxBlur.ColorBuffer[ColorResolverType.COUNT];
        for (int i = 0; i < ColorResolverType.COUNT; ++i) {
            buffers[i] = new BoxBlur.ColorBuffer(this.size, this.size);
        }
        BoxBlur.ColorBuffer mapGrass = buffers[ColorResolverType.GRASS.ordinal()];
        BoxBlur.ColorBuffer mapFoliage = buffers[ColorResolverType.FOLIAGE.ordinal()];
        BoxBlur.ColorBuffer mapWater = buffers[ColorResolverType.WATER.ordinal()];
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                class_1959 biome = this.slice.getBiome(this.inset + x, this.inset + y, this.inset + z);
                int index = z * this.size + x;
                mapGrass.setARGB(index, biome.method_8711((double)(this.worldX + x), (double)(this.worldZ + z)));
                mapFoliage.setARGB(index, biome.method_8698());
                mapWater.setARGB(index, biome.method_8687());
            }
        }
        if (this.radius > 0) {
            for (BoxBlur.ColorBuffer buffer : buffers) {
                BoxBlur.blur(buffer, this.radius);
            }
        }
        return new CachedColorBuffers(buffers);
    }

    private static class CachedColorBuffers {
        private final BoxBlur.ColorBuffer[] buffers;

        private CachedColorBuffers(BoxBlur.ColorBuffer[] buffers) {
            this.buffers = buffers;
        }

        public int get(ColorResolverType type, int x, int z) {
            BoxBlur.ColorBuffer buffer = this.buffers[type.ordinal()];
            return buffer.getARGB(buffer.getIndex(x, z));
        }
    }
}

