/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.region;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.arena.staging.StagingBuffer;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlTessellation;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.SharedQuadIndexBuffer;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkMeshFormats;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import net.minecraft.class_4076;
import org.apache.commons.lang3.Validate;

public class RenderRegion {
    public static final int REGION_WIDTH = 8;
    public static final int REGION_HEIGHT = 4;
    public static final int REGION_LENGTH = 8;
    private static final int REGION_WIDTH_M = 7;
    private static final int REGION_HEIGHT_M = 3;
    private static final int REGION_LENGTH_M = 7;
    private static final int REGION_WIDTH_SH = Integer.bitCount(7);
    private static final int REGION_HEIGHT_SH = Integer.bitCount(3);
    private static final int REGION_LENGTH_SH = Integer.bitCount(7);
    public static final int REGION_SIZE = 256;
    private static final int REGION_EXCESS = 8;
    private final int x;
    private final int y;
    private final int z;
    public final GlBufferArena vertexBuffers;
    public final Map<TerrainRenderPass, RenderRegionStorage> storage = new Reference2ReferenceOpenHashMap();

    public RenderRegion(CommandList commandList, StagingBuffer stagingBuffer, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        int stride = ChunkMeshFormats.COMPACT.getVertexFormat().getStride();
        this.vertexBuffers = new GlBufferArena(commandList, 193536, stride, stagingBuffer);
    }

    public static RenderRegion createRegionForChunk(CommandList commandList, StagingBuffer stagingBuffer, int x, int y, int z) {
        return new RenderRegion(commandList, stagingBuffer, x >> REGION_WIDTH_SH, y >> REGION_HEIGHT_SH, z >> REGION_LENGTH_SH);
    }

    public static long getRegionKeyForChunk(int x, int y, int z) {
        return class_4076.method_18685((int)(x >> REGION_WIDTH_SH), (int)(y >> REGION_HEIGHT_SH), (int)(z >> REGION_LENGTH_SH));
    }

    public int getOriginX() {
        return this.x << REGION_WIDTH_SH << 4;
    }

    public int getOriginY() {
        return this.y << REGION_HEIGHT_SH << 4;
    }

    public int getOriginZ() {
        return this.z << REGION_LENGTH_SH << 4;
    }

    public static int getChunkIndex(int x, int y, int z) {
        return x << 5 | y << 3 | z;
    }

    public void delete(CommandList commandList) {
        for (RenderRegionStorage storage : this.storage.values()) {
            storage.delete(commandList);
        }
        this.storage.clear();
        this.vertexBuffers.delete(commandList);
    }

    public void deleteTessellations(CommandList commandList) {
        for (RenderRegionStorage storage : this.storage.values()) {
            storage.deleteTessellation(commandList);
        }
    }

    public boolean isEmpty() {
        return this.vertexBuffers.isEmpty();
    }

    public long getDeviceUsedMemory() {
        return this.vertexBuffers.getDeviceUsedMemory();
    }

    public long getDeviceAllocatedMemory() {
        return this.vertexBuffers.getDeviceAllocatedMemory();
    }

    public RenderRegionStorage getStorage(TerrainRenderPass pass) {
        return this.storage.get(pass);
    }

    public RenderRegionStorage createStorage(TerrainRenderPass pass) {
        RenderRegionStorage storage = this.storage.get(pass);
        if (storage == null) {
            storage = new RenderRegionStorage();
            this.storage.put(pass, storage);
        }
        return storage;
    }

    public void deleteSection(RenderSection chunk) {
        this.storage.forEach((pass, regionStorage) -> {
            ChunkGraphicsState state = regionStorage.graphicsStates[chunk.getChunkId()];
            if (state != null) {
                state.delete();
                regionStorage.graphicsStates[chunk.getChunkId()] = null;
            }
        });
    }

    static {
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(8));
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(4));
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(8));
    }

    public static class RenderRegionStorage {
        private final ChunkGraphicsState[] graphicsStates = new ChunkGraphicsState[256];
        private final EnumMap<SharedQuadIndexBuffer.IndexType, GlTessellation> tessellations = new EnumMap(SharedQuadIndexBuffer.IndexType.class);

        public ChunkGraphicsState setState(RenderSection section, ChunkGraphicsState state) {
            int id = section.getChunkId();
            ChunkGraphicsState prev = this.graphicsStates[id];
            this.graphicsStates[id] = state;
            return prev;
        }

        public ChunkGraphicsState getState(RenderSection section) {
            return this.graphicsStates[section.getChunkId()];
        }

        public void updateTessellation(CommandList commandList, SharedQuadIndexBuffer.IndexType indexType, GlTessellation tessellation) {
            GlTessellation prev = this.tessellations.put(indexType, tessellation);
            if (prev != null) {
                prev.delete(commandList);
            }
        }

        public GlTessellation getTessellation(SharedQuadIndexBuffer.IndexType indexType) {
            return this.tessellations.get((Object)indexType);
        }

        public void delete(CommandList commandList) {
            this.deleteTessellation(commandList);
            for (int i = 0; i < this.graphicsStates.length; ++i) {
                ChunkGraphicsState state = this.graphicsStates[i];
                if (state == null) continue;
                state.delete();
                this.graphicsStates[i] = null;
            }
        }

        public void deleteTessellation(CommandList commandList) {
            for (GlTessellation tessellation : this.tessellations.values()) {
                tessellation.delete(commandList);
            }
            this.tessellations.clear();
        }

        public void replaceState(RenderSection section, ChunkGraphicsState state) {
            ChunkGraphicsState prev = this.setState(section, state);
            if (prev != null) {
                prev.delete();
            }
        }
    }
}

