/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.blender;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_3532;

public final class BiomeColorBlender {
    private final boolean useSmoothBlending;
    private final int[] cachedRet = new int[4];
    private final class_2338.class_2339 cachedPos = new class_2338.class_2339();

    public BiomeColorBlender(int radius) {
        this.useSmoothBlending = radius > 0;
    }

    public <T> int[] getColors(class_1920 world, class_2338 origin, ModelQuadView quad, ColorSampler<T> sampler, T state) {
        int[] colors = this.cachedRet;
        if (this.useSmoothBlending) {
            this.getColorsLinear(world, origin, quad, sampler, state, colors);
        } else {
            this.getColorsFlat(world, origin, quad, sampler, state, colors);
        }
        return colors;
    }

    private <T> void getColorsFlat(class_1920 world, class_2338 origin, ModelQuadView quad, ColorSampler<T> sampler, T state, int[] colors) {
        Arrays.fill(colors, ColorARGB.toABGR(sampler.getColor(state, world, origin, quad.getColorIndex())));
    }

    private <T> void getColorsLinear(class_1920 world, class_2338 origin, ModelQuadView quad, ColorSampler<T> sampler, T state, int[] colors) {
        for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
            colors[vertexIndex] = this.getVertexColor(world, origin, quad, sampler, state, vertexIndex);
        }
    }

    private <T> int getBlockColor(class_1920 world, T state, ColorSampler<T> sampler, int x, int y, int z, int colorIdx) {
        return sampler.getColor(state, world, (class_2338)this.cachedPos.method_10103(x, y, z), colorIdx);
    }

    private <T> int getVertexColor(class_1920 world, class_2338 origin, ModelQuadView quad, ColorSampler<T> sampler, T state, int vertexIdx) {
        float posX = quad.getX(vertexIdx) - 0.5f;
        float posY = quad.getY(vertexIdx) - 0.5f;
        float posZ = quad.getZ(vertexIdx) - 0.5f;
        int intX = class_3532.method_15375((float)posX);
        int intY = class_3532.method_15375((float)posY);
        int intZ = class_3532.method_15375((float)posZ);
        int worldIntX = origin.method_10263() + intX;
        int worldIntY = origin.method_10264() + intY;
        int worldIntZ = origin.method_10260() + intZ;
        int c00 = this.getBlockColor(world, state, sampler, worldIntX + 0, worldIntY, worldIntZ + 0, quad.getColorIndex());
        int c01 = this.getBlockColor(world, state, sampler, worldIntX + 0, worldIntY, worldIntZ + 1, quad.getColorIndex());
        int c10 = this.getBlockColor(world, state, sampler, worldIntX + 1, worldIntY, worldIntZ + 0, quad.getColorIndex());
        int c11 = this.getBlockColor(world, state, sampler, worldIntX + 1, worldIntY, worldIntZ + 1, quad.getColorIndex());
        int z0 = c00 != c01 ? ColorMixer.mix(c00, c01, posZ - (float)intZ) : c00;
        int z1 = c10 != c11 ? ColorMixer.mix(c10, c11, posZ - (float)intZ) : c10;
        int x0 = z0 != z1 ? ColorMixer.mix(z0, z1, posX - (float)intX) : z0;
        return ColorARGB.toABGR(x0);
    }
}

