/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.registry;

import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.block.IBindRenderLayer;
import net.darkhax.bookshelf.api.item.tab.TabBuilder;
import net.darkhax.bookshelf.api.registry.IContentLoader;
import net.darkhax.bookshelf.api.registry.IRegistryEntries;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.darkhax.bookshelf.impl.resources.WrappedReloadListener;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_7923;

public class ContentLoaderFabric
implements IContentLoader {
    @Override
    public void loadContent(RegistryDataProvider content) {
        this.consumeVanillaRegistry((IRegistryEntries)content.blocks, (class_2378)class_7923.field_41175);
        this.consumeVanillaRegistry((IRegistryEntries)content.fluids, (class_2378)class_7923.field_41173);
        this.consumeVanillaRegistry((IRegistryEntries)content.items, (class_2378)class_7923.field_41178);
        this.consumeVanillaRegistry(content.bannerPatterns, class_7923.field_41165);
        this.consumeVanillaRegistry(content.mobEffects, class_7923.field_41174);
        this.consumeVanillaRegistry(content.sounds, class_7923.field_41172);
        this.consumeVanillaRegistry((IRegistryEntries)content.potions, (class_2378)class_7923.field_41179);
        this.consumeVanillaRegistry(content.enchantments, class_7923.field_41176);
        this.consumeVanillaRegistry((IRegistryEntries)content.entities, (class_2378)class_7923.field_41177);
        this.consumeVanillaRegistry(content.blockEntities, class_7923.field_41181);
        this.consumeVanillaRegistry(content.particleTypes, class_7923.field_41180);
        this.consumeVanillaRegistry(content.menus, class_7923.field_41187);
        this.consumeVanillaRegistry(content.recipeSerializers, class_7923.field_41189);
        this.consumeVanillaRegistry((IRegistryEntries)content.paintings, (class_2378)class_7923.field_41182);
        this.consumeVanillaRegistry(content.attributes, class_7923.field_41190);
        this.consumeVanillaRegistry(content.stats, class_7923.field_41193);
        this.consumeVanillaRegistry((IRegistryEntries)content.villagerProfessions, (class_2378)class_7923.field_41195);
        this.consumeRegistry(content.commandArguments, (id, value) -> ArgumentTypeRegistry.registerArgumentType((class_2960)id, value.getType(), (class_2314)((class_2314)value.getSerializer().get())));
        this.consumeVanillaRegistry(content.recipeTypes, class_7923.field_41188);
        CommandRegistrationCallback.EVENT.register((dispatcher, access, environment) -> content.commands.build((id, value) -> value.build((CommandDispatcher<class_2168>)dispatcher, access, environment)));
        this.registerTradeData(content.trades.getVillagerTrades());
        this.registerWanderingTrades(content.trades.getCommonWanderingTrades(), content.trades.getRareWanderingTrades());
        this.consumeRegistry(content.dataListeners, (id, value) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new WrappedReloadListener((class_2960)id, (class_3302)value)));
        this.consumeRegistry(content.creativeTabs, (id, value) -> {
            TabBuilder builder = new TabBuilder(FabricItemGroup.builder((class_2960)id));
            value.accept(builder);
            builder.build();
        });
        if (Services.PLATFORM.isPhysicalClient()) {
            this.loadClient(content);
        }
    }

    private void loadClient(RegistryDataProvider content) {
        this.consumeRegistry(content.resourceListeners, (id, value) -> ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new WrappedReloadListener((class_2960)id, (class_3302)value)));
        for (class_2248 block : content.blocks) {
            if (!(block instanceof IBindRenderLayer)) continue;
            IBindRenderLayer bindLayer = (IBindRenderLayer)block;
            BlockRenderLayerMap.INSTANCE.putBlock(block, bindLayer.getRenderLayerToBind());
        }
    }

    private <T, O> void consumeVanillaRegistry(IRegistryEntries<O> toRegister, class_2378<T> registry, Function<O, T> wrapper) {
        toRegister.build((id, value) -> class_2378.method_10230((class_2378)registry, (class_2960)id, wrapper.apply(value)));
    }

    private <T> void consumeVanillaRegistry(IRegistryEntries<T> toRegister, class_2378<T> registry) {
        toRegister.build((id, value) -> class_2378.method_10230((class_2378)registry, (class_2960)id, (Object)value));
    }

    private <T> void consumeRegistry(IRegistryEntries<T> toRegister, BiConsumer<class_2960, T> func) {
        toRegister.build(func);
    }

    private void registerTradeData(Map<class_3852, Multimap<Integer, class_3853.class_1652>> villagerTrades) {
        for (Map.Entry<class_3852, Multimap<Integer, class_3853.class_1652>> professionData : villagerTrades.entrySet()) {
            Int2ObjectMap professionTrades = class_3853.field_17067.computeIfAbsent(professionData.getKey(), profession -> new Int2ObjectOpenHashMap());
            Iterator iterator = professionData.getValue().keySet().iterator();
            while (iterator.hasNext()) {
                int merchantTier = (Integer)iterator.next();
                ArrayList<class_3853.class_1652> tradesForTier = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])professionTrades.getOrDefault(merchantTier, (Object)new class_3853.class_1652[0])));
                tradesForTier.addAll(professionData.getValue().get((Object)merchantTier));
                professionTrades.put(merchantTier, (Object)tradesForTier.toArray(new class_3853.class_1652[0]));
            }
        }
    }

    private void registerWanderingTrades(List<class_3853.class_1652> commonTrades, List<class_3853.class_1652> rareTrades) {
        ArrayList<class_3853.class_1652> tradeData;
        if (!commonTrades.isEmpty()) {
            tradeData = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(1)));
            tradeData.addAll(commonTrades);
            class_3853.field_17724.put(1, (Object)tradeData.toArray(new class_3853.class_1652[0]));
        }
        if (!rareTrades.isEmpty()) {
            tradeData = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(2)));
            tradeData.addAll(rareTrades);
            class_3853.field_17724.put(2, (Object)tradeData.toArray(new class_3853.class_1652[0]));
        }
    }
}

