/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.google.gson.JsonObject;
import java.util.Map;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.mixin.accessors.item.crafting.AccessorShapedRecipe;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7710;

public final class ShapedDurabilityRecipe
extends class_1869 {
    public static final Serializer SERIALIZER = new Serializer();
    private final int damageAmount;
    private final class_1799 output;

    public ShapedDurabilityRecipe(class_2960 id, String group, class_7710 category, int width, int height, class_2371<class_1856> input, class_1799 output, int damageAmount) {
        super(id, group, category, width, height, input, output);
        this.damageAmount = damageAmount;
        this.output = output;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_2371<class_1799> getRemainingItems(class_1715 inv) {
        class_2371 keptItems = super.method_8111((class_1263)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (class_2371<class_1799>)keptItems, this.damageAmount);
    }

    public static final class Serializer
    implements class_1865<ShapedDurabilityRecipe> {
        public ShapedDurabilityRecipe fromJson(class_2960 id, JsonObject json) {
            String group = Serializers.STRING.fromJSON(json, "group", "");
            Map<String, class_1856> ingredients = AccessorShapedRecipe.bookshelf$keyFromJson(class_3518.method_15296((JsonObject)json, (String)"key"));
            String[] pattern = AccessorShapedRecipe.bookshelf$shrink(AccessorShapedRecipe.bookshelf$patternFromJson(class_3518.method_15261((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            class_2371<class_1856> inputs = AccessorShapedRecipe.bookshelf$dissolvePattern(pattern, ingredients, width, height);
            class_1799 output = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            int damageAmount = Serializers.INT.fromJSON(json, "damageAmount", 1);
            class_7710 category = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)json, (String)"category", null), (Enum)class_7710.field_40251);
            return new ShapedDurabilityRecipe(id, group, category, width, height, inputs, output, damageAmount);
        }

        public ShapedDurabilityRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            int width = buffer.readInt();
            int height = buffer.readInt();
            String group = buffer.method_19772();
            class_2371 input = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            for (int i = 0; i < input.size(); ++i) {
                input.set(i, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 output = buffer.method_10819();
            int damageAmount = buffer.readInt();
            class_7710 category = (class_7710)buffer.method_10818(class_7710.class);
            return new ShapedDurabilityRecipe(recipeId, group, category, width, height, (class_2371<class_1856>)input, output, damageAmount);
        }

        public void toNetwork(class_2540 buffer, ShapedDurabilityRecipe recipe) {
            buffer.writeInt(recipe.method_8150());
            buffer.writeInt(recipe.method_8158());
            buffer.method_10814(recipe.method_8112());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.output);
            buffer.writeInt(recipe.damageAmount);
            buffer.method_10817((Enum)recipe.method_45441());
        }
    }
}

