/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.util;

import io.github.bumblesoftware.fastload.common.FLCommonEvents;
import io.github.bumblesoftware.fastload.config.FLMath;
import io.github.bumblesoftware.fastload.init.Fastload;
import java.util.List;

public final class TickTimer {
    private int remainingTime = 0;

    public TickTimer(String location) {
        FLCommonEvents.Events.BOOLEAN_EVENT.registerThreadUnsafe(1L, List.of(location), event -> event.stableArgs((eventContext, eventArgs) -> {
            if (this.remainingTime > 0) {
                --this.remainingTime;
                if (FLMath.isDebugEnabled().booleanValue()) {
                    Fastload.LOGGER.info(String.valueOf(this.remainingTime));
                }
            }
        }));
    }

    public boolean isReady() {
        return this.remainingTime > 0;
    }

    public void setTime(int remainingTime) {
        if (remainingTime < 0) {
            throw new RuntimeException("FLTimer was called with a negative number!");
        }
        this.remainingTime = remainingTime;
    }

    public void setTime(int remainingTime, boolean inSeconds) {
        if (inSeconds) {
            remainingTime *= 20;
        }
        this.setTime(remainingTime);
    }

    public int getTime() {
        return this.remainingTime;
    }
}

