/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.api.external.events;

import io.github.bumblesoftware.fastload.api.external.events.AbstractEvent;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CapableEvent<Context>
implements AbstractEvent<Context> {
    private final Comparator<Long> order;
    public final List<String> locationList;
    public final Object2ObjectOpenHashMap<String, AbstractEvent.EventHolder<Context>> allEvents;
    public final Object2ObjectOpenHashMap<String, AbstractEvent.EventHolder<Context>> eventsToAdd;
    public final Object2ObjectOpenHashMap<String, AbstractEvent.EventHolder<Context>> eventsToRemove;

    public CapableEvent(Comparator<Long> eventOrder) {
        this.order = eventOrder;
        this.locationList = new ArrayList<String>();
        this.allEvents = new Object2ObjectOpenHashMap();
        this.eventsToAdd = new Object2ObjectOpenHashMap();
        this.eventsToRemove = new Object2ObjectOpenHashMap();
        this.allEvents.put((Object)"generic", this.getNewHolder());
        this.eventsToAdd.put((Object)"generic", this.getNewHolder());
        this.eventsToRemove.put((Object)"generic", this.getNewHolder());
    }

    public CapableEvent() {
        this(Comparator.reverseOrder());
    }

    @Override
    public void clean() {
        this.eventsToAdd.clear();
        this.eventsToRemove.clear();
        for (String location : this.getLocationList()) {
            AbstractEvent.EventHolder eventHolder = (AbstractEvent.EventHolder)this.getStorage().get((Object)location);
            if (eventHolder == null) {
                this.getStorage().remove((Object)location);
                continue;
            }
            ArrayList<Long> emptyPriorities = new ArrayList<Long>();
            for (Long priority : eventHolder.priorityHolder()) {
                if (!((List)eventHolder.argsHolder().get(priority.longValue())).isEmpty()) continue;
                emptyPriorities.add(priority);
            }
            for (Long priority : emptyPriorities) {
                eventHolder.priorityHolder().remove(priority);
                eventHolder.argsHolder().remove(priority.longValue());
            }
        }
    }

    @Override
    public Object2ObjectOpenHashMap<String, AbstractEvent.EventHolder<Context>> getStorage() {
        return this.allEvents;
    }

    @Override
    public List<String> getLocationList() {
        return this.locationList;
    }

    @Override
    public void removeThreadSafe(long priority, List<String> locations, AbstractEvent.EventArgs<Context> eventArgs) {
        for (String string : locations) {
            this.eventsToRemove.putIfAbsent((Object)string, this.getNewHolder());
            AbstractEvent.EventHolder holder = (AbstractEvent.EventHolder)this.eventsToRemove.get((Object)string);
            if (!holder.priorityHolder().contains(priority)) {
                holder.priorityHolder().add(priority);
            }
            if (!holder.argsHolder().containsKey(priority)) {
                ArrayList<AbstractEvent.EventArgs<Context>> list = new ArrayList<AbstractEvent.EventArgs<Context>>();
                list.add(eventArgs);
                holder.argsHolder().put(priority, list);
                continue;
            }
            if (((List)holder.argsHolder().get(priority)).contains(eventArgs)) continue;
            ((List)holder.argsHolder().get(priority)).add(eventArgs);
        }
    }

    @Override
    public void removeThreadUnsafe(long priority, List<String> locations, AbstractEvent.EventArgs<Context> eventArgs) {
        for (String string : locations) {
            AbstractEvent.EventHolder holder = (AbstractEvent.EventHolder)this.getStorage().get((Object)string);
            ((List)holder.argsHolder().get(priority)).remove(eventArgs);
            if (!((List)holder.argsHolder().get(priority)).isEmpty()) continue;
            holder.argsHolder().remove(priority);
            holder.priorityHolder().remove(priority);
        }
    }

    @Override
    public void registerThreadsafe(long priority, List<String> locations, AbstractEvent.ArgsProvider<Context> argsProvider) {
        for (String location : locations) {
            this.eventsToAdd.putIfAbsent((Object)location, this.getNewHolder());
            AbstractEvent.EventHolder holder = (AbstractEvent.EventHolder)this.eventsToAdd.get((Object)location);
            AbstractEvent.EventArgs<Context> eventArgs = argsProvider.getEvent(this);
            if (!holder.priorityHolder().contains(priority)) {
                holder.priorityHolder().add(priority);
            }
            if (!holder.argsHolder().containsKey(priority)) {
                ArrayList<AbstractEvent.EventArgs<Context>> list = new ArrayList<AbstractEvent.EventArgs<Context>>();
                list.add(eventArgs);
                holder.argsHolder().put(priority, list);
                continue;
            }
            if (((List)holder.argsHolder().get(priority)).contains(eventArgs)) continue;
            ((List)holder.argsHolder().get(priority)).add(eventArgs);
        }
    }

    @Override
    public void registerThreadUnsafe(long priority, List<String> locations, AbstractEvent.ArgsProvider<Context> argsProvider) {
        for (String location : locations) {
            this.allEvents.putIfAbsent((Object)location, this.getNewHolder());
            AbstractEvent.EventHolder holder = (AbstractEvent.EventHolder)this.allEvents.get((Object)location);
            ArrayList<Long> priHol = holder.priorityHolder();
            Long2ObjectMap argHol = holder.argsHolder();
            AbstractEvent.EventArgs<Context> eventArgs = argsProvider.getEvent(this);
            if (!this.locationList.contains(location)) {
                this.locationList.add(location);
            }
            if (!priHol.contains(priority)) {
                priHol.add(priority);
            }
            if (!argHol.containsKey(priority)) {
                ArrayList<AbstractEvent.EventArgs<Context>> list = new ArrayList<AbstractEvent.EventArgs<Context>>();
                list.add(eventArgs);
                argHol.put(priority, list);
                continue;
            }
            if (((List)argHol.get(priority)).contains(eventArgs)) continue;
            ((List)argHol.get(priority)).add(eventArgs);
        }
    }

    private void iterate(AbstractEvent.EventHolder<Context> holder, ArgsIterator<Context> argsIterator) {
        if (holder != null) {
            for (long priority : holder.priorityHolder()) {
                for (AbstractEvent.EventArgs arg : (List)holder.argsHolder().get(priority)) {
                    if (arg == null) continue;
                    argsIterator.onElement(priority, arg);
                }
            }
        }
    }

    @Override
    public void fire(List<String> locations, boolean orderFlipped, Context eventContext) {
        for (String string : locations) {
            AbstractEvent.EventHolder add = (AbstractEvent.EventHolder)this.eventsToAdd.get((Object)string);
            AbstractEvent.EventHolder all = (AbstractEvent.EventHolder)this.allEvents.get((Object)string);
            AbstractEvent.EventHolder remove = (AbstractEvent.EventHolder)this.eventsToRemove.remove((Object)string);
            Comparator<Long> order = orderFlipped ? this.order.reversed() : this.order;
            this.iterate(add, (priority, eventArgs) -> this.registerThreadUnsafe(priority, event -> eventArgs));
            all.priorityHolder().sort(order);
            this.iterate(all, (priority, eventArgs) -> eventArgs.recursive(eventContext, this, 0, eventArgs));
            this.iterate(remove, this::removeThreadUnsafe);
        }
        this.clean();
    }

    private static interface ArgsIterator<Ctx> {
        public void onElement(long var1, AbstractEvent.EventArgs<Ctx> var3);
    }
}

