/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.parsing;

import java.util.Arrays;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kroppeb.stareval.expression.Expression;
import kroppeb.stareval.function.AbstractTypedFunction;
import kroppeb.stareval.function.FunctionContext;
import kroppeb.stareval.function.FunctionResolver;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.Type;
import kroppeb.stareval.function.TypedFunction;
import net.coderbot.iris.parsing.BooleanVectorizedFunction;
import net.coderbot.iris.parsing.MatrixType;
import net.coderbot.iris.parsing.SmoothFloat;
import net.coderbot.iris.parsing.VectorConstructor;
import net.coderbot.iris.parsing.VectorType;
import net.coderbot.iris.parsing.VectorizedFunction;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.joml.Vector4i;

public class IrisFunctions {
    static final FunctionResolver.Builder builder;
    public static final FunctionResolver functions;

    static <T extends TypedFunction> void addVectorized(String string, T t) {
        if (!(t.getReturnType() instanceof Type.Primitive)) {
            throw new IllegalArgumentException(string + " is not vectorizable");
        }
        IrisFunctions.add(string, new VectorizedFunction(t, 2));
        IrisFunctions.add(string, new VectorizedFunction(t, 3));
        IrisFunctions.add(string, new VectorizedFunction(t, 4));
    }

    static <T extends TypedFunction> void addVectorizable(String string, T t) {
        IrisFunctions.add(string, t);
        IrisFunctions.addVectorized(string, t);
    }

    static <T extends TypedFunction> void addBooleanVectorizable(String string, T t) {
        assert (t.getReturnType().equals(Type.Boolean));
        IrisFunctions.add(string, t);
        if (!(t.getReturnType() instanceof Type.Primitive)) {
            throw new IllegalArgumentException(string + " is not vectorizable");
        }
        IrisFunctions.add(string, new BooleanVectorizedFunction(t, 2));
        IrisFunctions.add(string, new BooleanVectorizedFunction(t, 3));
        IrisFunctions.add(string, new BooleanVectorizedFunction(t, 4));
    }

    static <T> void addUnaryOpJOML(String string, VectorType.JOMLVector<T> jOMLVector, BiConsumer<T, T> biConsumer) {
        class Net_coderbot_iris_parsing_IrisFunctions$38
        extends AbstractTypedFunction {
            private final T vector;
            final /* synthetic */ VectorType.JOMLVector val$type;
            final /* synthetic */ BiConsumer val$function;

            Net_coderbot_iris_parsing_IrisFunctions$38(Type type, Type[] typeArray, VectorType.JOMLVector jOMLVector, BiConsumer biConsumer) {
                this.val$type = jOMLVector;
                this.val$function = biConsumer;
                super(type, typeArray);
                this.vector = this.val$type.create();
            }

            @Override
            public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                expressionArray[0].evaluateTo(functionContext, functionReturn);
                Object object = functionReturn.objectReturn;
                this.val$function.accept(object, this.vector);
                functionReturn.objectReturn = this.vector;
            }
        }
        builder.add(string, new Net_coderbot_iris_parsing_IrisFunctions$38(jOMLVector, new Type[]{jOMLVector}, jOMLVector, biConsumer));
    }

    static <T> void addBinaryOpJOML(String string, VectorType.JOMLVector<T> jOMLVector, TriConsumer<T, T, T> triConsumer) {
        class Net_coderbot_iris_parsing_IrisFunctions$39
        extends AbstractTypedFunction {
            private final T vector;
            final /* synthetic */ VectorType.JOMLVector val$type;
            final /* synthetic */ TriConsumer val$function;

            Net_coderbot_iris_parsing_IrisFunctions$39(Type type, Type[] typeArray, VectorType.JOMLVector jOMLVector, TriConsumer triConsumer) {
                this.val$type = jOMLVector;
                this.val$function = triConsumer;
                super(type, typeArray);
                this.vector = this.val$type.create();
            }

            @Override
            public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                expressionArray[0].evaluateTo(functionContext, functionReturn);
                Object object = functionReturn.objectReturn;
                expressionArray[1].evaluateTo(functionContext, functionReturn);
                Object object2 = functionReturn.objectReturn;
                this.val$function.accept(object, object2, this.vector);
                functionReturn.objectReturn = this.vector;
            }
        }
        builder.add(string, new Net_coderbot_iris_parsing_IrisFunctions$39(jOMLVector, new Type[]{jOMLVector, jOMLVector}, jOMLVector, triConsumer));
    }

    static <T> void addTernaryOpJOML(String string, VectorType.JOMLVector<T> jOMLVector, QuadConsumer<T, T, T, T> quadConsumer) {
        class Net_coderbot_iris_parsing_IrisFunctions$40
        extends AbstractTypedFunction {
            private final T vector;
            final /* synthetic */ VectorType.JOMLVector val$type;
            final /* synthetic */ QuadConsumer val$function;

            Net_coderbot_iris_parsing_IrisFunctions$40(Type type, Type[] typeArray, VectorType.JOMLVector jOMLVector, QuadConsumer quadConsumer) {
                this.val$type = jOMLVector;
                this.val$function = quadConsumer;
                super(type, typeArray);
                this.vector = this.val$type.create();
            }

            @Override
            public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                expressionArray[0].evaluateTo(functionContext, functionReturn);
                Object object = functionReturn.objectReturn;
                expressionArray[1].evaluateTo(functionContext, functionReturn);
                Object object2 = functionReturn.objectReturn;
                expressionArray[2].evaluateTo(functionContext, functionReturn);
                Object object3 = functionReturn.objectReturn;
                this.val$function.accept(object, object2, object3, this.vector);
                functionReturn.objectReturn = this.vector;
            }
        }
        builder.add(string, new Net_coderbot_iris_parsing_IrisFunctions$40(jOMLVector, new Type[]{jOMLVector, jOMLVector, jOMLVector}, jOMLVector, quadConsumer));
    }

    static <T> void addBinaryToBooleanOpJOML(String string, VectorType.JOMLVector<T> jOMLVector, boolean bl, ObjectObject2BooleanFunction<T, T> objectObject2BooleanFunction) {
        class Net_coderbot_iris_parsing_IrisFunctions$41
        extends AbstractTypedFunction {
            final /* synthetic */ ObjectObject2BooleanFunction val$function;
            final /* synthetic */ boolean val$inverted;

            Net_coderbot_iris_parsing_IrisFunctions$41(Type type, Type[] typeArray, ObjectObject2BooleanFunction objectObject2BooleanFunction, boolean bl) {
                this.val$function = objectObject2BooleanFunction;
                this.val$inverted = bl;
                super(type, typeArray);
            }

            @Override
            public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                expressionArray[0].evaluateTo(functionContext, functionReturn);
                Object object = functionReturn.objectReturn;
                expressionArray[1].evaluateTo(functionContext, functionReturn);
                Object object2 = functionReturn.objectReturn;
                functionReturn.objectReturn = this.val$function.apply(object, object2) != this.val$inverted;
            }
        }
        builder.add(string, new Net_coderbot_iris_parsing_IrisFunctions$41(jOMLVector, new Type[]{jOMLVector, jOMLVector}, objectObject2BooleanFunction, bl));
    }

    static <T extends TypedFunction> void add(String string, T t) {
        builder.add(string, t);
    }

    static void addCast(String string, final Type type, final Type type2, final Consumer<FunctionReturn> consumer) {
        class Net_coderbot_iris_parsing_IrisFunctions$42
        implements TypedFunction {
            Net_coderbot_iris_parsing_IrisFunctions$42() {
            }

            @Override
            public Type getReturnType() {
                return type2;
            }

            @Override
            public TypedFunction.Parameter[] getParameters() {
                return new TypedFunction.Parameter[]{new TypedFunction.Parameter(type)};
            }

            @Override
            public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                expressionArray[0].evaluateTo(functionContext, functionReturn);
                consumer.accept(functionReturn);
            }
        }
        IrisFunctions.add(string, new Net_coderbot_iris_parsing_IrisFunctions$42());
    }

    static void addImplicitCast(Type type, Type type2, Consumer<FunctionReturn> consumer) {
        IrisFunctions.addCast("<cast>", type, type2, consumer);
        IrisFunctions.addExplicitCast(type, type2, consumer);
    }

    static void addExplicitCast(Type type, Type type2, Consumer<FunctionReturn> consumer) {
        IrisFunctions.addCast("to" + type2.getClass().getSimpleName(), type, type2, consumer);
    }

    public static void main(String[] stringArray) {
        functions.logAllFunctions();
    }

    private static /* synthetic */ float lambda$static$62(Random random, float f, float f2) {
        return f + random.nextFloat() * (f2 - f);
    }

    private static /* synthetic */ int lambda$static$61(Random random, int n, int n2) {
        return random.nextInt(n2 - n) + n;
    }

    static {
        int n4;
        Object object2;
        int n5;
        int n6;
        builder = new FunctionResolver.Builder();
        IrisFunctions.addVectorizable("negate", n -> -n);
        IrisFunctions.add("negate", f -> -f);
        IrisFunctions.addUnaryOpJOML("negate", VectorType.VEC2, Vector2f::negate);
        IrisFunctions.addUnaryOpJOML("negate", VectorType.VEC3, Vector3f::negate);
        IrisFunctions.addUnaryOpJOML("negate", VectorType.VEC4, Vector4f::negate);
        IrisFunctions.addVectorizable("add", Integer::sum);
        IrisFunctions.add("add", Float::sum);
        IrisFunctions.addBinaryOpJOML("add", VectorType.VEC2, Vector2f::add);
        IrisFunctions.addBinaryOpJOML("add", VectorType.VEC3, Vector3f::add);
        IrisFunctions.addBinaryOpJOML("add", VectorType.VEC4, Vector4f::add);
        IrisFunctions.addVectorizable("subtract", (n, n2) -> n - n2);
        IrisFunctions.add("subtract", (f, f2) -> f - f2);
        IrisFunctions.addBinaryOpJOML("subtract", VectorType.VEC2, Vector2f::sub);
        IrisFunctions.addBinaryOpJOML("subtract", VectorType.VEC3, Vector3f::sub);
        IrisFunctions.addBinaryOpJOML("subtract", VectorType.VEC4, Vector4f::sub);
        IrisFunctions.addVectorizable("multiply", (n, n2) -> n * n2);
        IrisFunctions.add("multiply", (f, f2) -> f * f2);
        IrisFunctions.addBinaryOpJOML("multiply", VectorType.VEC2, Vector2f::mul);
        IrisFunctions.addBinaryOpJOML("multiply", VectorType.VEC3, Vector3f::mul);
        IrisFunctions.addBinaryOpJOML("multiply", VectorType.VEC4, Vector4f::mul);
        IrisFunctions.add("divide", (f, f2) -> f / f2);
        IrisFunctions.addBinaryOpJOML("divide", VectorType.VEC2, Vector2f::div);
        IrisFunctions.addBinaryOpJOML("divide", VectorType.VEC3, Vector3f::div);
        IrisFunctions.addBinaryOpJOML("divide", VectorType.VEC4, Vector4f::div);
        IrisFunctions.addVectorizable("remainder", (n, n2) -> n % n2);
        IrisFunctions.add("remainder", (f, f2) -> f % f2);
        IrisFunctions.addBooleanVectorizable("equals", (n, n2) -> n == n2);
        IrisFunctions.add("equals", (f, f2) -> f == f2);
        IrisFunctions.addBinaryToBooleanOpJOML("equal", VectorType.VEC2, false, Vector2f::equals);
        IrisFunctions.addBinaryToBooleanOpJOML("equal", VectorType.VEC3, false, Vector3f::equals);
        IrisFunctions.addBinaryToBooleanOpJOML("equal", VectorType.VEC4, false, Vector4f::equals);
        IrisFunctions.addBooleanVectorizable("notEquals", (n, n2) -> n != n2);
        IrisFunctions.add("notEquals", (f, f2) -> f != f2);
        IrisFunctions.addBinaryToBooleanOpJOML("equal", VectorType.VEC2, true, Vector2f::equals);
        IrisFunctions.addBinaryToBooleanOpJOML("equal", VectorType.VEC3, true, Vector3f::equals);
        IrisFunctions.addBinaryToBooleanOpJOML("equal", VectorType.VEC4, true, Vector4f::equals);
        IrisFunctions.add("lessThanOrEquals", (n, n2) -> n <= n2);
        IrisFunctions.add("lessThanOrEquals", (f, f2) -> f <= f2);
        IrisFunctions.add("moreThanOrEquals", (n, n2) -> n >= n2);
        IrisFunctions.add("moreThanOrEquals", (f, f2) -> f >= f2);
        IrisFunctions.add("lessThan", (n, n2) -> n < n2);
        IrisFunctions.add("lessThan", (f, f2) -> f < f2);
        IrisFunctions.add("moreThan", (n, n2) -> n > n2);
        IrisFunctions.add("moreThan", (f, f2) -> f > f2);
        IrisFunctions.addVectorizable("equals", (bl, bl2) -> bl == bl2);
        IrisFunctions.addVectorizable("notEquals", (bl, bl2) -> bl != bl2);
        IrisFunctions.addVectorizable("and", (bl, bl2) -> bl && bl2);
        IrisFunctions.addVectorizable("or", (bl, bl2) -> bl || bl2);
        IrisFunctions.addVectorizable("not", bl -> !bl);
        IrisFunctions.add("torad", f -> (float)Math.toRadians(f));
        IrisFunctions.add("todeg", f -> (float)Math.toDegrees(f));
        IrisFunctions.add("radians", f -> (float)Math.toRadians(f));
        IrisFunctions.add("degrees", f -> (float)Math.toDegrees(f));
        IrisFunctions.add("sin", f -> (float)Math.sin(f));
        IrisFunctions.add("cos", f -> (float)Math.cos(f));
        IrisFunctions.add("tan", f -> (float)Math.tan(f));
        IrisFunctions.add("asin", f -> (float)Math.asin(f));
        IrisFunctions.add("acos", f -> (float)Math.acos(f));
        IrisFunctions.add("atan", f -> (float)Math.atan(f));
        IrisFunctions.add("atan", (f, f2) -> (float)Math.atan2(f, f2));
        IrisFunctions.add("atan2", (f, f2) -> (float)Math.atan2(f, f2));
        IrisFunctions.add("pow", (f, f2) -> (float)Math.pow(f, f2));
        IrisFunctions.add("exp", f -> (float)Math.exp(f));
        IrisFunctions.add("log", f -> (float)Math.log(f));
        IrisFunctions.add("exp2", f -> (float)Math.pow(2.0, f));
        IrisFunctions.add("log2", f -> (float)(Math.log(f) / Math.log(2.0)));
        IrisFunctions.add("sqrt", f -> (float)Math.sqrt(f));
        IrisFunctions.add("log10", f -> (float)Math.log10(f));
        IrisFunctions.add("log", (f, f2) -> (float)(Math.log(f2) / Math.log(f)));
        IrisFunctions.add("exp10", f -> (float)Math.pow(10.0, f));
        IrisFunctions.addVectorizable("abs", Math::abs);
        IrisFunctions.add("abs", Math::abs);
        IrisFunctions.addUnaryOpJOML("abs", VectorType.VEC2, Vector2f::absolute);
        IrisFunctions.addUnaryOpJOML("abs", VectorType.VEC3, Vector3f::absolute);
        IrisFunctions.addUnaryOpJOML("abs", VectorType.VEC4, Vector4f::absolute);
        IrisFunctions.add("sign", Math::signum);
        IrisFunctions.add("signum", Math::signum);
        IrisFunctions.add("floor", f -> (float)Math.floor(f));
        IrisFunctions.add("floor", f -> (int)Math.floor(f));
        IrisFunctions.addUnaryOpJOML("floor", VectorType.VEC2, Vector2f::floor);
        IrisFunctions.addUnaryOpJOML("floor", VectorType.VEC3, Vector3f::floor);
        IrisFunctions.addUnaryOpJOML("floor", VectorType.VEC4, Vector4f::floor);
        IrisFunctions.add("ceil", f -> (float)Math.ceil(f));
        IrisFunctions.add("ceil", f -> (int)Math.ceil(f));
        IrisFunctions.addUnaryOpJOML("ceil", VectorType.VEC2, Vector2f::ceil);
        IrisFunctions.addUnaryOpJOML("ceil", VectorType.VEC3, Vector3f::ceil);
        IrisFunctions.addUnaryOpJOML("ceil", VectorType.VEC4, Vector4f::ceil);
        IrisFunctions.add("frac", f -> (float)((double)f - Math.floor(f)));
        IrisFunctions.addVectorizable("min", Math::min);
        IrisFunctions.add("min", Math::min);
        IrisFunctions.addBinaryOpJOML("min", VectorType.VEC2, Vector2f::min);
        IrisFunctions.addBinaryOpJOML("min", VectorType.VEC3, Vector3f::min);
        IrisFunctions.addBinaryOpJOML("min", VectorType.VEC4, Vector4f::min);
        IrisFunctions.addVectorizable("max", Math::max);
        IrisFunctions.add("max", Math::max);
        IrisFunctions.addBinaryOpJOML("max", VectorType.VEC2, Vector2f::max);
        IrisFunctions.addBinaryOpJOML("max", VectorType.VEC3, Vector3f::max);
        IrisFunctions.addBinaryOpJOML("max", VectorType.VEC4, Vector4f::max);
        for (int i = 3; i <= 16; ++i) {
            Object[] objectArray = new Type[i];
            Arrays.fill(objectArray, Type.Float);
            class Net_coderbot_iris_parsing_IrisFunctions$1
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$1(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    float f = functionReturn.floatReturn;
                    for (int i = 1; i < expressionArray.length; ++i) {
                        expressionArray[1].evaluateTo(functionContext, functionReturn);
                        f = Math.min(f, functionReturn.floatReturn);
                    }
                    functionReturn.floatReturn = f;
                }
            }
            IrisFunctions.add("min", new Net_coderbot_iris_parsing_IrisFunctions$1(Type.Float, (Type[])objectArray));
            objectArray = new Type[i];
            Arrays.fill(objectArray, Type.Float);
            class Net_coderbot_iris_parsing_IrisFunctions$2
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$2(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    float f = functionReturn.floatReturn;
                    for (int i = 1; i < expressionArray.length; ++i) {
                        expressionArray[1].evaluateTo(functionContext, functionReturn);
                        f = Math.max(f, functionReturn.floatReturn);
                    }
                    functionReturn.floatReturn = f;
                }
            }
            IrisFunctions.add("max", new Net_coderbot_iris_parsing_IrisFunctions$2(Type.Float, (Type[])objectArray));
            objectArray = new Type[i];
            Arrays.fill(objectArray, Type.Int);
            class Net_coderbot_iris_parsing_IrisFunctions$3
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$3(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    int n = functionReturn.intReturn;
                    for (int i = 1; i < expressionArray.length; ++i) {
                        expressionArray[1].evaluateTo(functionContext, functionReturn);
                        n = Math.min(n, functionReturn.intReturn);
                    }
                    functionReturn.intReturn = n;
                }
            }
            IrisFunctions.addVectorizable("min", new Net_coderbot_iris_parsing_IrisFunctions$3(Type.Int, (Type[])objectArray));
            objectArray = new Type[i];
            Arrays.fill(objectArray, Type.Int);
            class Net_coderbot_iris_parsing_IrisFunctions$4
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$4(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    int n = functionReturn.intReturn;
                    for (int i = 1; i < expressionArray.length; ++i) {
                        expressionArray[1].evaluateTo(functionContext, functionReturn);
                        n = Math.max(n, functionReturn.intReturn);
                    }
                    functionReturn.intReturn = n;
                }
            }
            IrisFunctions.addVectorizable("max", new Net_coderbot_iris_parsing_IrisFunctions$4(Type.Int, (Type[])objectArray));
        }
        IrisFunctions.addVectorizable("clamp", (n, n2, n3) -> Math.max(n2, Math.min(n3, n)));
        IrisFunctions.add("clamp", (f, f2, f3) -> Math.max(f2, Math.min(f3, f)));
        IrisFunctions.addTernaryOpJOML("clamp", VectorType.VEC2, (vector2f, vector2f2, vector2f3, vector2f4) -> {
            vector2f.min((Vector2fc)vector2f3, vector2f4);
            vector2f4.max((Vector2fc)vector2f2);
        });
        IrisFunctions.addTernaryOpJOML("clamp", VectorType.VEC3, (vector3f, vector3f2, vector3f3, vector3f4) -> {
            vector3f.min((Vector3fc)vector3f3, vector3f4);
            vector3f4.max((Vector3fc)vector3f2);
        });
        IrisFunctions.addTernaryOpJOML("clamp", VectorType.VEC4, (vector4f, vector4f2, vector4f3, vector4f4) -> {
            vector4f.min((Vector4fc)vector4f3, vector4f4);
            vector4f4.max((Vector4fc)vector4f2);
        });
        IrisFunctions.add("mix", (f, f2, f3) -> f + (f2 - f) * f3);
        IrisFunctions.addVectorizable("edge", (n, n2) -> n2 < n ? 0 : 1);
        IrisFunctions.add("edge", (f, f2) -> f2 < f ? 0.0f : 1.0f);
        IrisFunctions.addVectorizable("fmod", Math::floorMod);
        IrisFunctions.add("fmod", (f, f2) -> (f % f2 + f2) % f2);
        Type[] typeArray = new Random();
        IrisFunctions.addVectorizable("randomInt", ((Random)typeArray)::nextInt);
        IrisFunctions.addVectorizable("randomInt", ((Random)typeArray)::nextInt);
        IrisFunctions.addVectorizable("randomInt", (arg_0, arg_1) -> IrisFunctions.lambda$static$61((Random)typeArray, arg_0, arg_1));
        IrisFunctions.add("random", ((Random)typeArray)::nextFloat);
        IrisFunctions.add("random", (arg_0, arg_1) -> IrisFunctions.lambda$static$62((Random)typeArray, arg_0, arg_1));
        for (Type type : Type.AllPrimitives) {
            class Net_coderbot_iris_parsing_IrisFunctions$5
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$5(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    expressionArray[functionReturn.booleanReturn ? 1 : 2].evaluateTo(functionContext, functionReturn);
                }
            }
            IrisFunctions.add("if", new Net_coderbot_iris_parsing_IrisFunctions$5(type, new Type[]{Type.Boolean, type, type}));
        }
        typeArray = VectorType.AllVectorTypes;
        int n7 = typeArray.length;
        for (n6 = 0; n6 < n7; ++n6) {
            Type type;
            type = typeArray[n6];
            class Net_coderbot_iris_parsing_IrisFunctions$6
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$6(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    expressionArray[functionReturn.booleanReturn ? 1 : 2].evaluateTo(functionContext, functionReturn);
                }
            }
            IrisFunctions.add("if", new Net_coderbot_iris_parsing_IrisFunctions$6(type, new Type[]{Type.Boolean, type, type}));
        }
        for (n5 = 2; n5 <= 16; ++n5) {
            for (Type type : Type.AllPrimitives) {
                object2 = new Type[n5 * 2 + 1];
                for (n4 = 0; n4 < n5 * 2; n4 += 2) {
                    object2[n4] = Type.Boolean;
                    object2[n4 + 1] = type;
                }
                object2[n5 * 2] = type;
                n4 = n5 * 2;
                class Net_coderbot_iris_parsing_IrisFunctions$7
                extends AbstractTypedFunction {
                    final /* synthetic */ int val$finalLength;

                    Net_coderbot_iris_parsing_IrisFunctions$7(Type type, Type[] typeArray, int n) {
                        this.val$finalLength = n;
                        super(type, typeArray);
                    }

                    @Override
                    public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                        for (int i = 0; i < this.val$finalLength; i += 2) {
                            expressionArray[i].evaluateTo(functionContext, functionReturn);
                            if (functionReturn.booleanReturn) {
                                expressionArray[i + 1].evaluateTo(functionContext, functionReturn);
                                return;
                            }
                            expressionArray[this.val$finalLength].evaluateTo(functionContext, functionReturn);
                        }
                    }
                }
                IrisFunctions.add("if", new Net_coderbot_iris_parsing_IrisFunctions$7(type, (Type[])object2, n4));
            }
            Type[] typeArray2 = VectorType.AllVectorTypes;
            n6 = typeArray2.length;
            for (int i = 0; i < n6; ++i) {
                Type type;
                type = typeArray2[i];
                class Net_coderbot_iris_parsing_IrisFunctions$8
                extends AbstractTypedFunction {
                    Net_coderbot_iris_parsing_IrisFunctions$8(Type type, Type[] typeArray) {
                        super(type, typeArray);
                    }

                    @Override
                    public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                        expressionArray[0].evaluateTo(functionContext, functionReturn);
                        expressionArray[functionReturn.booleanReturn ? 1 : 2].evaluateTo(functionContext, functionReturn);
                    }
                }
                IrisFunctions.add("if", new Net_coderbot_iris_parsing_IrisFunctions$8(type, new Type[]{Type.Boolean, type, type}));
            }
        }
        builder.addDynamicFunction("smooth", Type.Float, () -> {
            class Net_coderbot_iris_parsing_IrisFunctions$9
            extends AbstractTypedFunction {
                private final SmoothFloat smoothFloat = new SmoothFloat();

                Net_coderbot_iris_parsing_IrisFunctions$9(Type type, TypedFunction.Parameter[] parameterArray, int n, boolean bl) {
                    super(type, parameterArray, n, bl);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    float f = functionReturn.floatReturn;
                    functionReturn.floatReturn = this.smoothFloat.updateAndGet(f, 1.0f, 1.0f);
                }
            }
            return new Net_coderbot_iris_parsing_IrisFunctions$9(Type.Float, new TypedFunction.Parameter[]{new TypedFunction.Parameter(Type.Float, false)}, 0, false);
        });
        builder.addDynamicFunction("smooth", Type.Float, () -> {
            class Net_coderbot_iris_parsing_IrisFunctions$10
            extends AbstractTypedFunction {
                private final SmoothFloat smoothFloat = new SmoothFloat();

                Net_coderbot_iris_parsing_IrisFunctions$10(Type type, TypedFunction.Parameter[] parameterArray, int n, boolean bl) {
                    super(type, parameterArray, n, bl);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[1].evaluateTo(functionContext, functionReturn);
                    float f = functionReturn.floatReturn;
                    functionReturn.floatReturn = this.smoothFloat.updateAndGet(f, 1.0f, 1.0f);
                }
            }
            return new Net_coderbot_iris_parsing_IrisFunctions$10(Type.Float, new TypedFunction.Parameter[]{new TypedFunction.Parameter(Type.Float, true), new TypedFunction.Parameter(Type.Float, false)}, 1, false);
        });
        builder.addDynamicFunction("smooth", Type.Float, () -> {
            class Net_coderbot_iris_parsing_IrisFunctions$11
            extends AbstractTypedFunction {
                private final SmoothFloat smoothFloat = new SmoothFloat();

                Net_coderbot_iris_parsing_IrisFunctions$11(Type type, TypedFunction.Parameter[] parameterArray, int n, boolean bl) {
                    super(type, parameterArray, n, bl);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    float f = functionReturn.floatReturn;
                    expressionArray[1].evaluateTo(functionContext, functionReturn);
                    float f2 = functionReturn.floatReturn;
                    functionReturn.floatReturn = this.smoothFloat.updateAndGet(f, f2, f2);
                }
            }
            return new Net_coderbot_iris_parsing_IrisFunctions$11(Type.Float, new TypedFunction.Parameter[]{new TypedFunction.Parameter(Type.Float, false), new TypedFunction.Parameter(Type.Float, false)}, 0, false);
        });
        builder.addDynamicFunction("smooth", Type.Float, () -> {
            class Net_coderbot_iris_parsing_IrisFunctions$12
            extends AbstractTypedFunction {
                private final SmoothFloat smoothFloat = new SmoothFloat();

                Net_coderbot_iris_parsing_IrisFunctions$12(Type type, TypedFunction.Parameter[] parameterArray, int n, boolean bl) {
                    super(type, parameterArray, n, bl);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[1].evaluateTo(functionContext, functionReturn);
                    float f = functionReturn.floatReturn;
                    expressionArray[2].evaluateTo(functionContext, functionReturn);
                    float f2 = functionReturn.floatReturn;
                    functionReturn.floatReturn = this.smoothFloat.updateAndGet(f, f2, f2);
                }
            }
            return new Net_coderbot_iris_parsing_IrisFunctions$12(Type.Float, new TypedFunction.Parameter[]{new TypedFunction.Parameter(Type.Float, true), new TypedFunction.Parameter(Type.Float, false), new TypedFunction.Parameter(Type.Float, false)}, 1, false);
        });
        builder.addDynamicFunction("smooth", Type.Float, () -> {
            class Net_coderbot_iris_parsing_IrisFunctions$13
            extends AbstractTypedFunction {
                private final SmoothFloat smoothFloat = new SmoothFloat();

                Net_coderbot_iris_parsing_IrisFunctions$13(Type type, TypedFunction.Parameter[] parameterArray, int n, boolean bl) {
                    super(type, parameterArray, n, bl);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    float f = functionReturn.floatReturn;
                    expressionArray[1].evaluateTo(functionContext, functionReturn);
                    float f2 = functionReturn.floatReturn;
                    expressionArray[2].evaluateTo(functionContext, functionReturn);
                    float f3 = functionReturn.floatReturn;
                    functionReturn.floatReturn = this.smoothFloat.updateAndGet(f, f2, f3);
                }
            }
            return new Net_coderbot_iris_parsing_IrisFunctions$13(Type.Float, new TypedFunction.Parameter[]{new TypedFunction.Parameter(Type.Float, false), new TypedFunction.Parameter(Type.Float, false), new TypedFunction.Parameter(Type.Float, false)}, 0, false);
        });
        builder.addDynamicFunction("smooth", Type.Float, () -> {
            class Net_coderbot_iris_parsing_IrisFunctions$14
            extends AbstractTypedFunction {
                private final SmoothFloat smoothFloat = new SmoothFloat();

                Net_coderbot_iris_parsing_IrisFunctions$14(Type type, TypedFunction.Parameter[] parameterArray, int n, boolean bl) {
                    super(type, parameterArray, n, bl);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[1].evaluateTo(functionContext, functionReturn);
                    float f = functionReturn.floatReturn;
                    expressionArray[2].evaluateTo(functionContext, functionReturn);
                    float f2 = functionReturn.floatReturn;
                    expressionArray[3].evaluateTo(functionContext, functionReturn);
                    float f3 = functionReturn.floatReturn;
                    functionReturn.floatReturn = this.smoothFloat.updateAndGet(f, f2, f3);
                }
            }
            return new Net_coderbot_iris_parsing_IrisFunctions$14(Type.Float, new TypedFunction.Parameter[]{new TypedFunction.Parameter(Type.Float, true), new TypedFunction.Parameter(Type.Float, false), new TypedFunction.Parameter(Type.Float, false), new TypedFunction.Parameter(Type.Float, false)}, 1, false);
        });
        IrisFunctions.addImplicitCast(Type.Int, Type.Float, functionReturn -> {
            functionReturn.floatReturn = functionReturn.intReturn;
        });
        IrisFunctions.addExplicitCast(Type.Float, Type.Int, functionReturn -> {
            functionReturn.intReturn = (int)functionReturn.floatReturn;
        });
        IrisFunctions.add("between", (n, n2, n3) -> n >= n2 && n <= n3);
        IrisFunctions.add("between", (f, f2, f3) -> f >= f2 && f <= f3);
        IrisFunctions.add("equals", (f, f2, f3) -> Math.abs(f - f2) <= f3);
        n5 = 2;
        while (n5 <= 32) {
            Object[] objectArray = new Type[n5];
            Arrays.fill(objectArray, Type.Float);
            n6 = n5++;
            class Net_coderbot_iris_parsing_IrisFunctions$15
            extends AbstractTypedFunction {
                final /* synthetic */ int val$finalLength;

                Net_coderbot_iris_parsing_IrisFunctions$15(Type type, Type[] typeArray, int n) {
                    this.val$finalLength = n;
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    float f = functionReturn.floatReturn;
                    for (int i = 1; i < this.val$finalLength; ++i) {
                        expressionArray[i].evaluateTo(functionContext, functionReturn);
                        if (functionReturn.floatReturn != f) continue;
                        functionReturn.booleanReturn = true;
                        return;
                    }
                    functionReturn.booleanReturn = false;
                }
            }
            IrisFunctions.add("in", new Net_coderbot_iris_parsing_IrisFunctions$15(Type.Boolean, (Type[])objectArray, n6));
        }
        for (Type.Primitive primitive : new Type.Primitive[]{Type.Boolean, Type.Int}) {
            for (int i = 2; i <= 4; ++i) {
                object2 = new VectorConstructor((Type)primitive, i);
                IrisFunctions.add(Character.toLowerCase(primitive.getClass().getSimpleName().charAt(0)) + "vec" + i, object2);
            }
        }
        class Net_coderbot_iris_parsing_IrisFunctions$16
        extends AbstractTypedFunction {
            Net_coderbot_iris_parsing_IrisFunctions$16(Type type, Type[] typeArray) {
                super(type, typeArray);
            }

            @Override
            public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                expressionArray[0].evaluateTo(functionContext, functionReturn);
                float f = functionReturn.floatReturn;
                expressionArray[1].evaluateTo(functionContext, functionReturn);
                float f2 = functionReturn.floatReturn;
                functionReturn.objectReturn = new Vector2f(f, f2);
            }
        }
        IrisFunctions.add("vec2", new Net_coderbot_iris_parsing_IrisFunctions$16(VectorType.VEC2, new Type[]{Type.Float, Type.Float}));
        class Net_coderbot_iris_parsing_IrisFunctions$17
        extends AbstractTypedFunction {
            Net_coderbot_iris_parsing_IrisFunctions$17(Type type, Type[] typeArray) {
                super(type, typeArray);
            }

            @Override
            public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                expressionArray[0].evaluateTo(functionContext, functionReturn);
                float f = functionReturn.floatReturn;
                expressionArray[1].evaluateTo(functionContext, functionReturn);
                float f2 = functionReturn.floatReturn;
                expressionArray[2].evaluateTo(functionContext, functionReturn);
                float f3 = functionReturn.floatReturn;
                functionReturn.objectReturn = new Vector3f(f, f2, f3);
            }
        }
        IrisFunctions.add("vec3", new Net_coderbot_iris_parsing_IrisFunctions$17(VectorType.VEC3, new Type[]{Type.Float, Type.Float, Type.Float}));
        class Net_coderbot_iris_parsing_IrisFunctions$18
        extends AbstractTypedFunction {
            Net_coderbot_iris_parsing_IrisFunctions$18(Type type, Type[] typeArray) {
                super(type, typeArray);
            }

            @Override
            public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                expressionArray[0].evaluateTo(functionContext, functionReturn);
                float f = functionReturn.floatReturn;
                expressionArray[1].evaluateTo(functionContext, functionReturn);
                float f2 = functionReturn.floatReturn;
                expressionArray[2].evaluateTo(functionContext, functionReturn);
                float f3 = functionReturn.floatReturn;
                expressionArray[3].evaluateTo(functionContext, functionReturn);
                float f4 = functionReturn.floatReturn;
                functionReturn.objectReturn = new Vector4f(f, f2, f3, f4);
            }
        }
        IrisFunctions.add("vec4", new Net_coderbot_iris_parsing_IrisFunctions$18(VectorType.VEC4, new Type[]{Type.Float, Type.Float, Type.Float, Type.Float}));
        Type.Primitive[] primitiveArray = new String[][]{{"0", "r", "x", "s"}, {"1", "g", "y", "t"}, {"2", "b", "z", "p"}, {"3", "a", "w", "q"}};
        for (Type.Primitive primitive : primitiveArray[0]) {
            class Net_coderbot_iris_parsing_IrisFunctions$19
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$19(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.floatReturn = ((Vector2f)functionReturn.objectReturn).x;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$19(Type.Float, new Type[]{VectorType.VEC2}));
            class Net_coderbot_iris_parsing_IrisFunctions$20
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$20(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.intReturn = ((Vector2i)functionReturn.objectReturn).x;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$20(Type.Int, new Type[]{VectorType.I_VEC2}));
            class Net_coderbot_iris_parsing_IrisFunctions$21
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$21(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.floatReturn = ((Vector3f)functionReturn.objectReturn).x;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$21(Type.Float, new Type[]{VectorType.VEC3}));
            class Net_coderbot_iris_parsing_IrisFunctions$22
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$22(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.intReturn = ((Vector3i)functionReturn.objectReturn).x;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$22(Type.Int, new Type[]{VectorType.I_VEC3}));
            class Net_coderbot_iris_parsing_IrisFunctions$23
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$23(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.floatReturn = ((Vector4f)functionReturn.objectReturn).x;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$23(Type.Float, new Type[]{VectorType.VEC4}));
            class Net_coderbot_iris_parsing_IrisFunctions$24
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$24(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.intReturn = ((Vector4i)functionReturn.objectReturn).x;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$24(Type.Int, new Type[]{VectorType.I_VEC4}));
        }
        for (Type.Primitive primitive : primitiveArray[1]) {
            class Net_coderbot_iris_parsing_IrisFunctions$25
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$25(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.floatReturn = ((Vector2f)functionReturn.objectReturn).y;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$25(Type.Float, new Type[]{VectorType.VEC2}));
            class Net_coderbot_iris_parsing_IrisFunctions$26
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$26(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.intReturn = ((Vector2i)functionReturn.objectReturn).y;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$26(Type.Int, new Type[]{VectorType.I_VEC2}));
            class Net_coderbot_iris_parsing_IrisFunctions$27
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$27(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.floatReturn = ((Vector3f)functionReturn.objectReturn).y;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$27(Type.Float, new Type[]{VectorType.VEC3}));
            class Net_coderbot_iris_parsing_IrisFunctions$28
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$28(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.intReturn = ((Vector3i)functionReturn.objectReturn).y;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$28(Type.Int, new Type[]{VectorType.I_VEC3}));
            class Net_coderbot_iris_parsing_IrisFunctions$29
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$29(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.floatReturn = ((Vector4f)functionReturn.objectReturn).y;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$29(Type.Float, new Type[]{VectorType.VEC4}));
            class Net_coderbot_iris_parsing_IrisFunctions$30
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$30(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.intReturn = ((Vector4i)functionReturn.objectReturn).y;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$30(Type.Int, new Type[]{VectorType.I_VEC4}));
        }
        for (Type.Primitive primitive : primitiveArray[2]) {
            class Net_coderbot_iris_parsing_IrisFunctions$31
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$31(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.floatReturn = ((Vector3f)functionReturn.objectReturn).z;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$31(Type.Float, new Type[]{VectorType.VEC3}));
            class Net_coderbot_iris_parsing_IrisFunctions$32
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$32(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.intReturn = ((Vector3i)functionReturn.objectReturn).z;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$32(Type.Int, new Type[]{VectorType.I_VEC3}));
            class Net_coderbot_iris_parsing_IrisFunctions$33
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$33(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.floatReturn = ((Vector4f)functionReturn.objectReturn).z;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$33(Type.Float, new Type[]{VectorType.VEC4}));
            class Net_coderbot_iris_parsing_IrisFunctions$34
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$34(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.intReturn = ((Vector4i)functionReturn.objectReturn).z;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$34(Type.Int, new Type[]{VectorType.I_VEC4}));
        }
        for (Type.Primitive primitive : primitiveArray[3]) {
            class Net_coderbot_iris_parsing_IrisFunctions$35
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$35(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.floatReturn = ((Vector4f)functionReturn.objectReturn).w;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$35(Type.Float, new Type[]{VectorType.VEC4}));
            class Net_coderbot_iris_parsing_IrisFunctions$36
            extends AbstractTypedFunction {
                Net_coderbot_iris_parsing_IrisFunctions$36(Type type, Type[] typeArray) {
                    super(type, typeArray);
                }

                @Override
                public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                    expressionArray[0].evaluateTo(functionContext, functionReturn);
                    functionReturn.intReturn = ((Vector4i)functionReturn.objectReturn).w;
                }
            }
            IrisFunctions.add("<access$" + (String)((Object)primitive) + ">", new Net_coderbot_iris_parsing_IrisFunctions$36(Type.Int, new Type[]{VectorType.I_VEC4}));
        }
        for (int i = 0; i < 4; ++i) {
            for (Object object2 : primitiveArray[i]) {
                n4 = i;
                class Net_coderbot_iris_parsing_IrisFunctions$37
                extends AbstractTypedFunction {
                    final /* synthetic */ int val$finalI;

                    Net_coderbot_iris_parsing_IrisFunctions$37(Type type, Type[] typeArray, int n) {
                        this.val$finalI = n;
                        super(type, typeArray);
                    }

                    @Override
                    public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
                        expressionArray[0].evaluateTo(functionContext, functionReturn);
                        functionReturn.objectReturn = ((Matrix4f)functionReturn.objectReturn).getColumn(this.val$finalI, new Vector4f());
                    }
                }
                IrisFunctions.add("<access$" + (String)object2 + ">", new Net_coderbot_iris_parsing_IrisFunctions$37(VectorType.VEC4, new Type[]{MatrixType.MAT4}, n4));
            }
        }
        functions = builder.build();
    }

    static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }

    static interface QuadConsumer<T, U, V, W> {
        public void accept(T var1, U var2, V var3, W var4);
    }

    static interface ObjectObject2BooleanFunction<T, U> {
        public boolean apply(T var1, U var2);
    }
}

