/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.shader_overrides;

import com.mojang.blaze3d.systems.RenderSystem;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.render.chunk.ShaderChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkProgramOverrides;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkShaderInterface;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.ShaderChunkRendererExt;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.shadows.ShadowRenderingState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderChunkRenderer.class})
public class MixinShaderChunkRenderer
implements ShaderChunkRendererExt {
    @Unique
    private IrisChunkProgramOverrides irisChunkProgramOverrides;
    @Unique
    private GlProgram<IrisChunkShaderInterface> override;
    @Shadow(remap=false)
    private GlProgram<ChunkShaderInterface> activeProgram;
    @Shadow(remap=false)
    @Final
    protected ChunkVertexType vertexType;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    private void iris$onInit(RenderDevice renderDevice, ChunkVertexType chunkVertexType, CallbackInfo callbackInfo) {
        this.irisChunkProgramOverrides = new IrisChunkProgramOverrides();
    }

    @Inject(method={"begin"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void iris$begin(TerrainRenderPass terrainRenderPass, CallbackInfo callbackInfo) {
        terrainRenderPass.startDrawing();
        this.override = this.irisChunkProgramOverrides.getProgramOverride(terrainRenderPass, this.vertexType);
        this.irisChunkProgramOverrides.bindFramebuffer(terrainRenderPass);
        if (this.override == null) {
            return;
        }
        callbackInfo.cancel();
        this.activeProgram = null;
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            RenderSystem.disableCull();
        }
        this.override.bind();
        ((IrisChunkShaderInterface)this.override.getInterface()).setup();
    }

    @Inject(method={"end"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void iris$onEnd(TerrainRenderPass terrainRenderPass, CallbackInfo callbackInfo) {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        this.irisChunkProgramOverrides.unbindFramebuffer();
        if (this.override != null) {
            ((IrisChunkShaderInterface)this.override.getInterface()).restore();
            this.override.unbind();
            terrainRenderPass.endDrawing();
            this.override = null;
            callbackInfo.cancel();
        }
    }

    @Inject(method={"delete"}, at={@At(value="HEAD")}, remap=false)
    private void iris$onDelete(CallbackInfo callbackInfo) {
        this.irisChunkProgramOverrides.deleteShaders();
    }

    @Override
    public GlProgram<IrisChunkShaderInterface> iris$getOverride() {
        return this.override;
    }
}

