/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp;

import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatRegistry;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.QuadViewClouds;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;

public final class CloudVertex {
    public static final VertexFormatDescription FORMAT = VertexFormatRegistry.instance().get(IrisVertexFormats.CLOUDS);
    public static final int STRIDE = IrisVertexFormats.CLOUDS.method_1362();
    private static final int OFFSET_POSITION = 0;
    private static final int OFFSET_COLOR = 12;
    private static final QuadViewClouds.QuadViewCloudsUnsafe quad = new QuadViewClouds.QuadViewCloudsUnsafe();
    private static final Vector3f saveNormal = new Vector3f();
    private static int vertexCount;

    public static void write(long l, Matrix4f matrix4f, float f, float f2, float f3, int n) {
        float f4 = MatrixHelper.transformPositionX((Matrix4f)matrix4f, (float)f, (float)f2, (float)f3);
        float f5 = MatrixHelper.transformPositionY((Matrix4f)matrix4f, (float)f, (float)f2, (float)f3);
        float f6 = MatrixHelper.transformPositionZ((Matrix4f)matrix4f, (float)f, (float)f2, (float)f3);
        CloudVertex.write(l, f4, f5, f6, n);
        if (++vertexCount == 4) {
            vertexCount = 0;
            quad.setup(l, STRIDE);
            NormalHelper.computeFaceNormal(saveNormal, quad);
            int n2 = NormalHelper.packNormal(saveNormal, 0.0f);
            for (long i = 0L; i < 4L; ++i) {
                MemoryUtil.memPutInt((long)(l + 16L - (long)STRIDE * i), (int)n2);
            }
        }
    }

    public static void write(long l, float f, float f2, float f3, int n) {
        MemoryUtil.memPutFloat((long)(l + 0L + 0L), (float)f);
        MemoryUtil.memPutFloat((long)(l + 0L + 4L), (float)f2);
        MemoryUtil.memPutFloat((long)(l + 0L + 8L), (float)f3);
        MemoryUtil.memPutInt((long)(l + 12L + 0L), (int)n);
        if (++vertexCount == 4) {
            vertexCount = 0;
            quad.setup(l, STRIDE);
            NormalHelper.computeFaceNormal(saveNormal, quad);
            int n2 = NormalHelper.packNormal(saveNormal, 0.0f);
            for (long i = 0L; i < 4L; ++i) {
                MemoryUtil.memPutInt((long)(l + 16L - (long)STRIDE * i), (int)n2);
            }
        }
    }
}

