# Description

Helps add jiggle physics to your cosmetics (or any in-game model). Please read the tutorial on how to do so below!

##### *Note*:
- This plugin can be used to add jiggle physics to any model loaded in-game. While this tutorial mainly focuses on cosmetics, the steps below can be applied to any rigged model in Unity.
- The tutorial below assumes you already have the MoreCompanyCosmeticPackage imported and set up in Unity already. You can find a tutorial for that **[HERE](https://github.com/notnotnotswipez/MoreCompany/wiki/Cosmetic-Creation)**

## BEFORE READING AHEAD: YOUR MODEL MUST BE RIGGED IN ORDER FOR JIGGLE PHYSICS TO WORK
If your model is not already rigged, you can watch this great video by [Seymour](https://twitter.com/spaghettitron/) ([his Thunderstore profile](https://thunderstore.io/c/lethal-company/p/ironbean/)) which covers rigging your model using Blender: <br><br>
[![Rigging Tutorial](https://cdn.discordapp.com/attachments/1193838003903275089/1199149828861595698/image.png?ex=65c17e4e&is=65af094e&hm=92b2c43ca7805e3a96280386e9e4c79558659ad730a3f180469863156d2f410e&)](https://youtu.be/ypDxRrLVGaE)

# Disclaimer/Credits
I only created the plugin for BepInEx to load, all the scripts this plugin uses was made by Naelstrof, I only compiled them. Again, NONE of the scripts/code was produced by me. You can find the GitHub project **[HERE](https://github.com/naelstrof/UnityJigglePhysics)**

# Video Tutorial
A video tutorial covering the information below can be viewed here: <br><br>
[![Rigging Tutorial](https://cdn.discordapp.com/attachments/1193838003903275089/1199152178967875655/image.png?ex=65c1807e&is=65af0b7e&hm=db53aed81e0e4a9533a828bb76f3890a215cd888c87fde33f15837b6e54e5379&)](https://youtu.be/eXf6NTUxE6A)

# Tutorial

## Getting Your Unity Project Setup
- Install this mod via r2modman or the thunderstore app
- Navigate to the folder where this mod was installed 
	- In r2modman/thunderstore app, you can click on Settings on the left-hand side and click on "Browse Profile Folder"
	- Here, you can click into  BepInEx -> plugins -> HGG-JigglePhysicsPlugin (Take note of the BepInEx folder as you will be navigating there again shortly)
- With your Unity project open, create a new folder, name it, and drag and drop the JigglePhysicsPlugin.dll from the HGG-JigglePhysicsPlugin folder into that folder (I have named mine "Test")
<details>
  <summary>Click Here For a Picture Reference</summary>
  
- ![](https://cdn.discordapp.com/attachments/1193838003903275089/1194481752383684679/image.png?ex=65b082d2&is=659e0dd2&hm=ef0988e1bb2fca2df4e9a7512eee4db7b62a002c9e783ddee3134c7c82e97af7&)

</details>

- Next, navigate to where your BepInEx is installed, and click into the "core" folder
<details>
  <summary>Click Here For a Picture Reference</summary>
  
- ![](https://cdn.discordapp.com/attachments/1194415781400805446/1194416340879020072/image.png?ex=65b045e6&is=659dd0e6&hm=a8a844f27d15cd35d746a427957bd981de2e35dc374e06f06ab734c5987e91fd&)

</details>

- Drag all the highlighted dll's into Unity, the same place you placed the JigglePhysicsPlugin.dll (Do NOT drag in BepInEx.Harmony.dll, it is unnecessary and will cause your Unity to crash) Your project should now look like this:
<details>
  <summary>Click Here For a Picture Reference</summary>
  
- ![](https://cdn.discordapp.com/attachments/1193838003903275089/1194477364877459558/image.png?ex=65b07ebc&is=659e09bc&hm=ab05ceb551e014eba5c2e49a7bd94e3eca3717d74293335efb73b4f75e287c80&)

</details>

- If the arrow besides the dll does not show up, you may have to close your Unity project and re-open it

## Adding Jiggle Physics To Your Model
- Click the arrow on the JigglePhysicsPlugin.dll and drag JiggleRigBuilder onto the model you want jiggle physics added to (I just copied the scavengermodel to test, do NOT move or add the script to the original)
<details>
  <summary>Click Here For a Picture Reference</summary>
  
- ![](https://cdn.discordapp.com/attachments/1193838003903275089/1194479290004287488/image.png?ex=65b08087&is=659e0b87&hm=6c3de94b9741c69ebbc44f4cd6160c826292640368c253760010a88b7c8b12ce&)

</details>

- In the Inspector, you should now see that "Jiggle Rig Builder (Script)" has been added as a component to your model
<details>
  <summary>Click Here For a Picture Reference</summary>
  
- ![](https://cdn.discordapp.com/attachments/1193838003903275089/1194479848287121418/image.png?ex=65b0810c&is=659e0c0c&hm=456c27219927664693c61393c806593b2d0e916a379e28597207d5c6b8dcea72&)

</details>

- In this script, you will want to drag the part of the model that you want jiggle physics to be added to onto "Root Transform"
<details>
  <summary>Click Here For a Picture Reference</summary>
  
- ![](https://cdn.discordapp.com/attachments/1193838003903275089/1194490661643227146/image.png?ex=65b08b1e&is=659e161e&hm=11a1be4ee7b5865e9bfdcf194d25ff52c465d937ad4bd6ecee5516ebe4ea9253&)

</details>

- Next, right click in the folder where your dll.'s were placed, click "Create" -> "JigglePhysics" -> "Settings", this will create a Jiggle Settings
<details>
  <summary>Click Here For a Picture Reference</summary>
  
- ![](https://cdn.discordapp.com/attachments/1193838003903275089/1194490734976454676/image.png?ex=65b08b2f&is=659e162f&hm=1a54fc6a5884118bfc7d3d7a327077c3d88a0212164aa272ac1011fc23bd9560&)

</details>

- Drag the newly created settings into the Jiggle Rig Builder (Script), into "Jiggle Settings"
<details>
  <summary>Click Here For a Picture Reference</summary>
  
- ![](https://cdn.discordapp.com/attachments/1193838003903275089/1194491348833804368/image.png?ex=65b08bc2&is=659e16c2&hm=d75f080f39c7fdf526eddb6286704638b8848cb1407e7b36a734f9e7fb41aa65&)

</details>

- Now, hit the Play button at the top of Unity and re-select the Scene view, this will allow you to move your model and see the physics in real-time
<details>
  <summary>Click Here For a Picture Reference</summary>
  
- ![](https://cdn.discordapp.com/attachments/1193838003903275089/1194492209676959844/image.png?ex=65b08c8f&is=659e178f&hm=dbf8ec7714c77f7b0e19802b2b34d3690d71e75b7fa097490b79f0e6f82f0ff6&)

</details>

- While in "Play mode", you can click on the Settings file you created earlier and adjust the settings to fit your needs
<details>
  <summary>Click Here For a Picture Reference</summary>
  
- ![](https://cdn.discordapp.com/attachments/1193838003903275089/1194492829062418462/image.png?ex=65b08d23&is=659e1823&hm=3083c0b2eb7073f7adf7a9132f9299baef04494dd444e72a39cc0d3b6b25e5c1&)

</details>

- Once you've tuned the physics to your liking, exit "Play mode", and follow the necessary steps to build your cosmetic. Those steps, again, can be found **[HERE](https://github.com/notnotnotswipez/MoreCompany/wiki/Cosmetic-Creation)**
- If done correctly, you should have added jiggle physics to your cosmetic, congrats!


# Contact
If you are having trouble or have any questions, you can reach out to me on discord @ **waga. / Waga#7703**